/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope tmouth it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_MOUTH_H
#define DOODLEHASH_MOUTH_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashMouth
{
  DoodleHashObject *base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
  guint32 connect_to_moustache_x;
  guint32 connect_to_moustache_y;
};

DoodleHashMouth* doodlehash_mouth_new();
DoodleHashMouth* doodlehash_mouth_copy(const DoodleHashMouth*orig);
DoodleHashMouth* doodlehash_mouth_load_from_svg_file(const char *file);
void doodlehash_mouth_get_width_and_height(DoodleHashMouth* mouth, guint32* width, guint32* height);
guint32 doodlehash_mouth_get_width(DoodleHashMouth* mouth);
guint32 doodlehash_mouth_get_height(DoodleHashMouth* mouth);
void doodlehash_mouth_set_width(DoodleHashMouth* mouth, guint32 width);
void doodlehash_mouth_set_height(DoodleHashMouth* mouth, guint32 height);
void doodlehash_mouth_get_head_connection_point(DoodleHashMouth* mouth, guint32* x, guint32* y);
guint32 doodlehash_mouth_get_head_connection_point_x(DoodleHashMouth* mouth);
guint32 doodlehash_mouth_get_head_connection_point_y(DoodleHashMouth* mouth);
void doodlehash_mouth_set_head_connection_point(DoodleHashMouth* mouth, guint32 x, guint32 y);
guint32 doodlehash_mouth_get_moustache_connection_point_x(DoodleHashMouth* mouth);
guint32 doodlehash_mouth_get_moustache_connection_point_y(DoodleHashMouth* mouth);
void doodlehash_mouth_get_moustache_connection_point(DoodleHashMouth* mouth, guint32* x, guint32* y);
void doodlehash_mouth_set_moustache_connection_point(DoodleHashMouth* mouth, guint32 x, guint32 y);
guint32 doodlehash_mouth_get_moustache_connection_point_x(DoodleHashMouth* mouth);
guint32 doodlehash_mouth_get_moustache_connection_point_y(DoodleHashMouth* mouth);
void doodlehash_mouth_set_random_colours(DoodleHashMouth* mouth, guint code);
void doodlehash_mouth_set_colours(DoodleHashMouth* mouth, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_mouth_get_fill_colour(DoodleHashMouth* mouth, guint code);
gchar *doodlehash_mouth_get_stroke_colour(DoodleHashMouth* mouth, guint code);
void doodlehash_mouth_scale(DoodleHashMouth *mouth, double scale);
void doodlehash_mouth_free(DoodleHashMouth* mouth);

G_END_DECLS
#endif /* DOODLEHASH_MOUTH_H */
