/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_HEAD_H
#define DOODLEHASH_HEAD_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashHead
{
  DoodleHashObject *base;
  guint32 connect_to_eyes_x;
  guint32 connect_to_eyes_y;
  guint32 connect_to_left_ear_x;
  guint32 connect_to_left_ear_y;
  guint32 connect_to_right_ear_x;
  guint32 connect_to_right_ear_y;
  guint32 connect_to_nose_x;
  guint32 connect_to_nose_y;
  guint32 connect_to_mouth_x;
  guint32 connect_to_mouth_y;
  guint32 connect_to_chin_x;
  guint32 connect_to_chin_y;
  guint32 connect_to_left_cheek_x;
  guint32 connect_to_left_cheek_y;
  guint32 connect_to_right_cheek_x;
  guint32 connect_to_right_cheek_y;
};
DoodleHashHead* doodlehash_head_new();
DoodleHashHead * doodlehash_head_copy(const DoodleHashHead*orig);
DoodleHashHead* doodlehash_head_load_from_svg_file(const char *file);
void doodlehash_head_get_width_and_height(DoodleHashHead* head, guint32* width, guint32* height);
guint32 doodlehash_head_get_width(DoodleHashHead* head);
guint32 doodlehash_head_get_height(DoodleHashHead* head);
void doodlehash_head_set_width(DoodleHashHead* head, guint32 width);
void doodlehash_head_set_height(DoodleHashHead* head, guint32 height);
void doodlehash_head_get_eyes_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
guint32 doodlehash_head_get_eyes_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_eyes_connection_point_y(DoodleHashHead* head);
void doodlehash_head_set_eyes_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_get_left_ear_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
void doodlehash_head_set_left_ear_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_get_right_ear_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
void doodlehash_head_set_right_ear_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
guint32 doodlehash_head_get_left_ear_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_left_ear_connection_point_y(DoodleHashHead* head);
guint32 doodlehash_head_get_right_ear_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_right_ear_connection_point_y(DoodleHashHead* head);
void doodlehash_head_get_nose_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
guint32 doodlehash_head_get_nose_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_nose_connection_point_y(DoodleHashHead* head);
void doodlehash_head_set_nose_connection_point(DoodleHashHead* head, guint32 x, guint32 y);

void doodlehash_head_get_mouth_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
guint32 doodlehash_head_get_mouth_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_mouth_connection_point_y(DoodleHashHead* head);
void doodlehash_head_set_mouth_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_get_chin_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
guint32 doodlehash_head_get_chin_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_chin_connection_point_y(DoodleHashHead* head);
void doodlehash_head_set_chin_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_get_left_cheek_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
guint32 doodlehash_head_get_left_cheek_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_left_cheek_connection_point_y(DoodleHashHead* head);
guint32 doodlehash_head_get_right_cheek_connection_point_x(DoodleHashHead* head);
guint32 doodlehash_head_get_right_cheek_connection_point_y(DoodleHashHead* head);
void doodlehash_head_set_left_cheek_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_get_right_cheek_connection_point(DoodleHashHead* head, guint32* x, guint32* y);
void doodlehash_head_set_right_cheek_connection_point(DoodleHashHead* head, guint32 x, guint32 y);
void doodlehash_head_set_random_colours(DoodleHashHead* head, guint code);
void doodlehash_head_set_colours(DoodleHashHead* head, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_head_get_fill_colour(DoodleHashHead* head, guint code);
gchar *doodlehash_head_get_stroke_colour(DoodleHashHead* head, guint code);
void doodlehash_head_scale(DoodleHashHead *head, double scale);
void doodlehash_head_free(DoodleHashHead* head);

G_END_DECLS
#endif /* DOODLEHASH_HEAD_H */
