/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#include <config.h>
#include "hair.h"
#include <libxml/tree.h>
#include <glib.h>
#include <string.h>
#include "util.h"
#include "object.h"
DoodleHashHair* doodlehash_hair_new()
{
  DoodleHashHair *h = g_malloc (sizeof (DoodleHashHair));
  if (!h)
    return NULL;
  memset (h, 0, sizeof (DoodleHashHair));
  h->base = doodlehash_object_new();
  return h;
}

DoodleHashHair* doodlehash_hair_copy(const DoodleHashHair*orig)
{
  DoodleHashHair *hair = doodlehash_hair_new();
  g_free (hair->base);
  hair->base = doodlehash_object_copy(orig->base);
  return hair;
}

DoodleHashHair* doodlehash_hair_load_from_svg_file(const char *file)
{
  DoodleHashHair* hair = doodlehash_hair_new();
  if (doodlehash_object_load_from_svg_file(hair->base, file) != 0)
    {
      doodlehash_hair_free (hair);
      return NULL;
    }
  return hair;
}

void doodlehash_hair_get_width_and_height(DoodleHashHair* hair, guint32* width, guint32* height)
{
  doodlehash_object_get_width_and_height(hair->base, width, height);
}

guint32 doodlehash_hair_get_width(DoodleHashHair* hair)
{
  return doodlehash_object_get_width(hair->base);
}

guint32 doodlehash_hair_get_height(DoodleHashHair* hair)
{
  return doodlehash_object_get_height(hair->base);
}

void doodlehash_hair_set_width(DoodleHashHair* hair, guint32 width)
{
  double scale = (double) width / (double)hair->base->width;
  doodlehash_object_set_width(hair->base, hair->base->width * scale);
}

void doodlehash_hair_set_height(DoodleHashHair* hair, guint32 height)
{
  double scale = (double) height / (double)hair->base->height;
  doodlehash_object_set_height(hair->base, hair->base->height * scale);
}

void doodlehash_hair_set_random_colours(DoodleHashHair* hair, guint code)
{
  doodlehash_object_set_random_colours(hair->base, code);
}
void doodlehash_hair_set_colours(DoodleHashHair* hair, guint code, char *s, char *f)
{
  doodlehash_object_set_colours(hair->base, code, s, f);
}

gchar *doodlehash_hair_get_fill_colour(DoodleHashHair* hair, guint code)
{
  return doodlehash_object_get_fill_colour(hair->base, code);
}

gchar *doodlehash_hair_get_stroke_colour(DoodleHashHair* hair, guint code)
{
  return doodlehash_object_get_stroke_colour(hair->base, code);
}

void doodlehash_hair_scale(DoodleHashHair *hair, double scale)
{
  doodlehash_object_scale(hair->base, scale);
}
void doodlehash_hair_free(DoodleHashHair* h)
{
  if (h && h->base)
    doodlehash_object_free (h->base);
  g_free (h);
}
