/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#include <config.h>
#include "face.h"
#include <libxml/tree.h>
#include <glib.h>
#include <string.h>
#include "util.h"
#include "object.h"
DoodleHashFace * doodlehash_face_new()
{
  DoodleHashFace *f = g_malloc (sizeof (DoodleHashFace));
  if (!f)
    return NULL;
  memset (f, 0, sizeof (DoodleHashFace));
  return f;
}
DoodleHashFace* doodlehash_face_copy(const DoodleHashFace *orig)
{
  DoodleHashFace *f = doodlehash_face_new();
  if (orig->cheeks)
    f->cheeks = doodlehash_cheeks_copy(orig->cheeks);
  if (orig->chin)
    f->chin = doodlehash_chin_copy(orig->chin);
  if (orig->ears)
    f->ears = doodlehash_ears_copy(orig->ears);
  if (orig->earrings)
    f->earrings = doodlehash_earrings_copy(orig->earrings);
  if (orig->eyebrows)
    f->eyebrows = doodlehash_eyebrows_copy(orig->eyebrows);
  if (orig->eyes)
    f->eyes = doodlehash_eyes_copy(orig->eyes);
  if (orig->hair)
    f->hair = doodlehash_hair_copy(orig->hair);
  if (orig->head)
    f->head = doodlehash_head_copy(orig->head);
  if (orig->moustache)
    f->moustache = doodlehash_moustache_copy(orig->moustache);
  if (orig->mouth)
    f->mouth = doodlehash_mouth_copy(orig->mouth);
  if (orig->nose)
    f->nose = doodlehash_nose_copy(orig->nose);
  if (orig->spectacles)
    f->spectacles = doodlehash_spectacles_copy(orig->spectacles);
  return f;
}

DoodleHashFace* doodlehash_face_load_from_svg_files(const char *ear_left_file, const char *ear_right_file, const char *earring_left_file, const char *earring_right_file, const char *eyes_file, const char *hair_file, const char *head_file, const char *moustache_file, const char *mouth_file, const char *nose_file, const char *eyebrow_left_file, const char *eyebrow_right_file, const char *chin_file, const char *cheek_left_file, const char *cheek_right_file, const char *spectacles_file)
{

  DoodleHashFace *f = doodlehash_face_new();
  f->cheeks = doodlehash_cheeks_load_from_svg_file(cheek_left_file, cheek_right_file);
  f->chin = doodlehash_chin_load_from_svg_file(chin_file);
  f->ears = doodlehash_ears_load_from_svg_file(ear_left_file, ear_right_file);
  f->earrings = doodlehash_earrings_load_from_svg_file(earring_left_file, earring_right_file);
  f->eyebrows = doodlehash_eyebrows_load_from_svg_file(eyebrow_left_file, eyebrow_right_file);
  f->eyes = doodlehash_eyes_load_from_svg_file(eyes_file);
  f->hair = doodlehash_hair_load_from_svg_file(hair_file);
  f->head = doodlehash_head_load_from_svg_file(head_file);
  f->moustache = doodlehash_moustache_load_from_svg_file(moustache_file);
  f->mouth = doodlehash_mouth_load_from_svg_file(mouth_file);
  f->nose = doodlehash_nose_load_from_svg_file(nose_file);
  f->spectacles = doodlehash_spectacles_load_from_svg_file(spectacles_file);
  return f;
}
DoodleHashCheekPair * doodlehash_face_get_cheeks(DoodleHashFace *f)
{
  return f->cheeks;
}
void doodlehash_face_set_cheeks(DoodleHashFace *f, DoodleHashCheekPair * cheeks)
{
  doodlehash_cheeks_free(f->cheeks);
  f->cheeks= doodlehash_cheeks_copy(cheeks);
}
DoodleHashChin *doodlehash_face_get_chin(DoodleHashFace *f)
{
  return f->chin;
}
void doodlehash_face_set_chin(DoodleHashFace *f, DoodleHashChin *chin)
{
  doodlehash_chin_free(f->chin);
  f->chin= doodlehash_chin_copy(chin);
}
DoodleHashEarPair *doodlehash_face_get_ears(DoodleHashFace *f)
{
  return f->ears;
}
void doodlehash_face_set_ears(DoodleHashFace *f, DoodleHashEarPair *ears)
{
  doodlehash_ears_free(f->ears);
  f->ears= doodlehash_ears_copy(ears);
}
DoodleHashEarRingPair *doodlehash_face_get_earrings(DoodleHashFace *f)
{
  return f->earrings;
}
void doodlehash_face_set_earrings(DoodleHashFace *f, DoodleHashEarRingPair *earrings)
{
  doodlehash_earrings_free(f->earrings);
  f->earrings= doodlehash_earrings_copy(earrings);
}
DoodleHashEyeBrowPair *doodlehash_face_get_eyebrows(DoodleHashFace *f)
{
  return f->eyebrows;
}
void doodlehash_face_set_eyebrows(DoodleHashFace *f, DoodleHashEyeBrowPair *eyebrows)
{
  doodlehash_eyebrows_free(f->eyebrows);
  f->eyebrows= doodlehash_eyebrows_copy(eyebrows);
}
DoodleHashEyes *doodlehash_face_get_eyes(DoodleHashFace *f)
{
  return f->eyes;
}
void doodlehash_face_set_eyes(DoodleHashFace *f, DoodleHashEyes *eyes)
{
  doodlehash_eyes_free(f->eyes);
  f->eyes= doodlehash_eyes_copy(eyes);
}
DoodleHashHair *doodlehash_face_get_hair(DoodleHashFace *f)
{
  return f->hair;
}
void doodlehash_face_set_hair(DoodleHashFace *f, DoodleHashHair *hair)
{
  doodlehash_hair_free(f->hair);
  f->hair= doodlehash_hair_copy(hair);
}
DoodleHashHead *doodlehash_face_get_head(DoodleHashFace *f)
{
  return f->head;
}
void doodlehash_face_set_head(DoodleHashFace *f, DoodleHashHead *head)
{
  doodlehash_head_free(f->head);
  f->head= doodlehash_head_copy(head);
} 
DoodleHashMoustache *doodlehash_face_get_moustache(DoodleHashFace *f)
{
  return f->moustache;
}
void doodlehash_face_set_moustache(DoodleHashFace *f, DoodleHashMoustache *moustache)
{
  doodlehash_moustache_free(f->moustache);
  f->moustache = doodlehash_moustache_copy(moustache);
}
DoodleHashMouth *doodlehash_face_get_mouth(DoodleHashFace *f)
{
  return f->mouth;
}
void doodlehash_face_set_mouth(DoodleHashFace *f, DoodleHashMouth *mouth)
{
  doodlehash_mouth_free(f->mouth);
  f->mouth = doodlehash_mouth_copy(mouth);
}
DoodleHashNose *doodlehash_face_get_nose(DoodleHashFace *f)
{
  return f->nose;
}
void doodlehash_face_set_nose(DoodleHashFace *f, DoodleHashNose *nose)
{
  doodlehash_nose_free(f->nose);
  f->nose = doodlehash_nose_copy(nose);
}
DoodleHashSpectacles *doodlehash_face_get_spectacles(DoodleHashFace *f)
{
  return f->spectacles;
}
void doodlehash_face_set_spectacles(DoodleHashFace *f, DoodleHashSpectacles *spectacles)
{
  doodlehash_spectacles_free(f->spectacles);
  f->spectacles = doodlehash_spectacles_copy(spectacles);
}
void doodlehash_face_set_random_colours(DoodleHashFace *f)
{
  if (f->earrings)
    doodlehash_earrings_set_random_matching_colours(f->earrings);
  if (f->spectacles)
    {
      doodlehash_spectacles_set_random_colours(f->spectacles, DOODLEHASH_COLOUR_PRIMARY);
      doodlehash_spectacles_set_random_colours(f->spectacles, DOODLEHASH_COLOUR_SECONDARY);
    }
      
  if (f->head)
    {
      /* we pass in an empty object when a part happens to be null. */
      DoodleHashObject *dummy = doodlehash_object_new();
      doodlehash_object_set_random_matching_colours
        (f->head->base, 
         f->hair ? f->hair->base : dummy,
         f->ears ? f->ears->left->base : dummy,
         f->ears ? f->ears->right->base : dummy,
         f->moustache ? f->moustache->base : dummy,
         f->mouth ? f->mouth->base : dummy,
         f->nose ? f->nose->base : dummy,
         f->eyebrows ? f->eyebrows->left->base : dummy,
         f->eyebrows ? f->eyebrows->right->base : dummy,
         f->chin ? f->chin->base : dummy,
         f->cheeks ? f->cheeks->right->base : dummy,
         NULL);
      doodlehash_object_free(dummy);
    }
}

void doodlehash_face_free(DoodleHashFace* f)
{
  if (f)
    {
  doodlehash_cheeks_free(f->cheeks);
  doodlehash_chin_free(f->chin);
  doodlehash_ears_free(f->ears);
  doodlehash_earrings_free(f->earrings);
  doodlehash_eyebrows_free(f->eyebrows);
  doodlehash_eyes_free(f->eyes);
  doodlehash_hair_free(f->hair);
  doodlehash_head_free(f->head);
  doodlehash_moustache_free(f->moustache);
  doodlehash_mouth_free(f->mouth);
  doodlehash_nose_free(f->nose);
  doodlehash_spectacles_free(f->spectacles);
      g_free (f);
    }
}
