/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <gdk/gdk.h>

#include "block.h"
#include "image.h"
#include "theme.h"

#ifndef SLIDE_H
#define SLIDE_H

G_BEGIN_DECLS

typedef struct _CriaSlide		CriaSlide;
typedef struct _CriaSlideClass		CriaSlideClass;
typedef struct _CriaSlidePrivate	CriaSlidePrivate;

#include "presentation.h"

void		cria_slide_add_block	       (CriaSlide	* self,
						CriaBlock	* block);
CriaImage*	cria_slide_get_background      (CriaSlide	* self);
GOColor*	cria_slide_get_background_color(CriaSlide	* self);
CriaBlock*	cria_slide_get_block	       (CriaSlide	* self,
						gchar const	* block);
CriaBlock*	cria_slide_get_block_no_recurse(CriaSlide	* self,
						gchar const	* block);
gchar**		cria_slide_get_block_names     (CriaSlide	* self);
GoPoint*	cria_slide_get_display_size    (CriaSlide	* self,
						GdkScreen	* screen);
CriaSlide*	cria_slide_get_master_slide    (CriaSlide	* self);
GoPoint*	cria_slide_get_size	       (CriaSlide	* self);
CriaTheme*	cria_slide_get_theme	       (CriaSlide	* self);
const gchar*	cria_slide_get_title	       (CriaSlide	* self);
GType		cria_slide_get_type	       (void);
CriaSlide*	cria_slide_new		       (CriaPresentation* presentation);
CriaSlide*	cria_slide_new_pos	       (CriaPresentation* presentation,
						gint		  pos);
void		cria_slide_set_background      (CriaSlide	* self,
						CriaImage	* background);
void		cria_slide_set_background_color(CriaSlide	* self,
						const GOColor	* color);
void		cria_slide_set_comment	       (CriaSlide	* self,
						const char	* comment);
void		cria_slide_set_master_slide    (CriaSlide	* self,
						CriaSlide	* master_slide);
void		cria_slide_set_theme	       (CriaSlide	* self,
						CriaTheme	* theme);
void		cria_slide_set_title	       (CriaSlide	* self,
						const char	* title);

#define CRIA_TYPE_SLIDE			(cria_slide_get_type ())
#define CRIA_SLIDE(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE, CriaSlide))
#define CRIA_SLIDE_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE, CriaSlideClass))
#define CRIA_IS_SLIDE(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE))
#define CRIA_IS_SLIDE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE))
#define CRIA_SLIDE_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE, CriaSlideClass))

struct _CriaSlide {
	GObject		  base_instance;
	gchar		* title;

	CriaSlidePrivate* priv;
};

struct _CriaSlideClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaSlide	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* SLIDE_H */
