/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: test_misc.cxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#include "../../src/cmgl.hxx"
#include <comf/comf.hxx>
#include <comf/mymacros.hxx>
using namespace comf;
using namespace cmgl;

class TestMisc : public Test
{
	public:

	TestMisc() {}

	void vrun()
	{
		minimal_0000();
		check_nan_0000();
		users_nan_0000();
	}
	

	protected:

	void minimal_0000()
	{
		Minimal<double> m;
		m &= 3;
		m &= -5;
		m &= 7;
		CHECKREAL(-5,m);
	}

	void users_nan_0000()
	{
		printf("# ");
		double x = NaN;
		const unsigned char * cx = reinterpret_cast<const unsigned char *>(&x);
		COMF_LOOP(size_t,j,sizeof(x))
			printf("%02X ",cx[j]);
		puts("");
	}

	void check_nan_0000()
	{
		const double n = NaN;
		CHECKBOOL(false,finite(n));
		CHECKBOOL(false,finite(-n));

	}




	
};

static TestMisc s_test;
Test * test_misc()
{
	return &s_test;
}


