/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: test_dxf.cxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#include <sys/stat.h>
#include <sys/types.h>

#include "../../src/cmgl.hxx"
#include <comf/comf.hxx>
#include <comf/mymacros.hxx>

using namespace comf;
using namespace cmgl;

class TestDXF : public Test
{
	public:
	TestDXF() {}

	void vrun()
	{
		user_dxf_0000();
		user_dxf_0001();
	}

	void user_dxf_0000()
	{
		std::string filename = 
			Format("/tmp/%$-0000.dxf") % utod(getpid());
		TextOutputFile file(filename.c_str(),0666,64*1024);
		Dxf dxf(file);
	}

	void user_dxf_0001()
	{
		std::string filename = 
			Format("/tmp/%$-0001.dxf") % utod(getpid());
		TextOutputFile file(filename.c_str(),0666,64*1024);
		Dxf dxf(file);
		Point2D p(1.0/3.0,1.234E70);
		dxf.draw(p);
	}


};


static TestDXF s_test;
Test * test_dxf()
{
	return &s_test;
}

