/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: vad.hxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#ifndef CMGL_VAD_HXX
#define CMGL_VAD_HXX

#include <comf/object.hxx>

#include "defs.hxx"

CMGL_NS_BEGIN

class VaD : public comf::Serializable
{
	DECLARE_SERIALIZABLE(VaD);
	
	friend const VaD operator + (const VaD & a, const VaD & b);
	friend const VaD operator - (const VaD & a, const VaD & b);
	friend const VaD operator * (const VaD & a, const VaD & b);
	friend const VaD operator * (const VaD & a, double b);
	friend const VaD operator * (double a, const VaD & b);
	friend const VaD operator / (const VaD & a, const VaD & b);
	friend const VaD operator / (const VaD & a, double b);
	friend const VaD operator / (double a, const VaD & b);

	friend bool operator == (const VaD & a, const VaD & b);
	friend bool operator != (const VaD & a, const VaD & b);
	friend bool operator > (const VaD & a, const VaD & b);
	friend bool operator < (const VaD & a, const VaD & b);
	friend bool operator >= (const VaD & a, const VaD & b);
	friend bool operator <= (const VaD & a, const VaD & b);
 
	friend const VaD pow(const VaD & a, const VaD & b);
	friend const VaD pow(const VaD & a, double b);
	friend const VaD pow(double a, const VaD & b);
	friend const VaD sqrt(const VaD & a);

	friend const VaD exp(const VaD & a);
	friend const VaD log(const VaD & a);
	
	
	protected:
	double _v;
	double _d;


	public:

	double val() {return _v;}
	double err() {return _d;}
	
	VaD();
	VaD(double v, double d);
	explicit VaD(double v);

	
	VaD & operator += (const VaD & a);
	VaD & operator -= (const VaD & a);
	VaD & operator *= (const VaD & a);
	VaD & operator /= (const VaD & a);
	const VaD & operator +();
	const VaD operator -();

	static const double stdError;

	void serialize(comf::BOStorage &) const;
	void serialize(comf::BIStorage &);
	void serialize(comf::TOStorage &) const;
	void serialize(comf::TIStorage &);

};

const VaD operator + (const VaD & a, const VaD & b);
const VaD operator - (const VaD & a, const VaD & b);
const VaD operator * (const VaD & a, const VaD & b);
const VaD operator * (const VaD & a, double b);
const VaD operator * (double a, const VaD & b);
const VaD operator / (const VaD & a, const VaD & b);
const VaD operator / (const VaD & a, double b);
const VaD operator / (double a, const VaD & b);

bool operator == (const VaD & a, const VaD & b);
bool operator != (const VaD & a, const VaD & b);
bool operator > (const VaD & a, const VaD & b);
bool operator < (const VaD & a, const VaD & b);
bool operator >= (const VaD & a, const VaD & b);
bool operator <= (const VaD & a, const VaD & b);
 
const VaD pow(const VaD & a, const VaD & b);
const VaD pow(const VaD & a, double b);
const VaD pow(double a, const VaD & b);
const VaD sqrt(const VaD & a);

const VaD exp(const VaD & a);
const VaD log(const VaD & a);

CMGL_NS_END

#endif
