/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: real.hxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#ifndef CMGL_REAL_HXX
#define CMGL_REAL_HXX

#include <stdint.h>
#include <utility>

#include <comf/defs.hxx>
#include <comf/types.hxx>

#include "types.hxx"

CMGL_NS_BEGIN

extern const double AUREA;    // parte aurea
extern const double COAUREA;

extern const double NaN;
double double_NaN();


// solves the 1st degree equation a*x+b=0
double solve1G(double a, double b);

// solves the 2nd degree equation a*x^2 + b*x + c = 0
// puts the lower solution in x1, and the higher in x2
// returns true id delta>=0
// if delta < 0 returns false, x1 and x2 are unchanged
std::pair<double,double> solve2G(double a, double b, double c);

double round(double x); /// rounds x to the neraest integer value

double angle_0_2Pi(double alfa);     /// porta l'angolo alfa nel range [0..2*Pi)
double angle_Pi_Pi(double alfa);     /// porta l'anfolo alfa nel range [-Pi..Pi)

double stirling(double x);                  /// formula di Stirling per il fattoriale
uint64_t factorial(uint64_t);               /// fattoriale esatto
double fibonacciGen(double x);              /// numeri di Fibonacci, generati con formula
uint64_t fibonacci(uint64_t);               /// numeri di Fibonacci, calcolati per iterazione


void solveC2G(const Complex & a, const Complex & b, const Complex & c, Complex & x1, Complex & x2);
// risolve in campo complesso un' equazione di secondo grado del tipo :
// a*x^2 + b*x + c = 0, le soluzioni sono messe in x1 e x2




CMGL_NS_END

#endif
