/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: real.cxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#include <math.h>

#include <comf/globals.hxx>
#include <comf/integer.hxx>

using namespace comf;
#define ASSERT COMF_ASSERT

#include "real.hxx"

CMGL_NS_BEGIN

const double AUREA = ((::sqrt(5.0) - 1.0)/2.0);        
const double COAUREA = ((-::sqrt(5.0) - 1.0)/2.0);
const double NaN = double_NaN();

double double_NaN()
{
	double x = std::numeric_limits<double>::signaling_NaN();
	ASSERT(!finite(x));
	return x;
}

double solve1G(const double a, const double b)
{
	return -b/a;
}


std::pair<double,double> solve2G(const double a, const double b, const double c)
{
	const double delta = sqr(b)-4*a*c;
	if(delta<0) return std::make_pair(NaN,NaN); //only for optimization
	const double sqdelta = ::sqrt(delta);
	return std::make_pair((-b + sqdelta)/(2*a), (-b - sqdelta)/(2*a));
}



double round(const double x)
{
	return floor(x + 0.5);
}



double angle_0_2Pi(const double a)
{
	double x = ::fmod(a,2*M_PI);
	if (x<0) x+= (2*M_PI);
	return x;
}

double angle_Pi_Pi(const double a)
{                            
	double x = ::fmod(a,2*M_PI);
	if (x> M_PI) x-= (2*M_PI);
	if (x<-M_PI) x+= (2*M_PI);
	return x;
}



double stirling(double x)
{
	return ::pow(x,x) * ::exp(-x) * ::sqrt(2*M_PI*x);
}


uint64_t factorial(uint64_t x)
{
	uint64_t p = 1;
	uint64_t j;
	for(j=x;j>1;--j) p *= j;
	return p;
}



double fibonacciGen(double x)
{
	return 1/(::sqrt(5)*::pow(AUREA,x)) - 1/(::sqrt(5)*::pow(COAUREA,x));
}



uint64_t fibonacci(uint64_t x)
{
	if(x<=1) return x;

	uint64_t a2 = 0;
	uint64_t a1 = 1;
	uint64_t p=0;

	uint64_t j;
	for(j=1;j<x;j++)
	{
		p = a1+a2;
		a2 = a1;
		a1 = p;
	};
 
	return p;
}


void solveC2G(const Complex & a, const Complex & b, const Complex & c, Complex & x1, Complex & x2)
{
	Complex qdelta = std::sqrt(b*b - a*c*4.0);
	x1 = (-b + qdelta)/2.0;
	x2 = (-b - qdelta)/2.0;
}



CMGL_NS_END
