/*
Copyright (C)  2006  Daniele Zelante

This file is part of cmgl.

cmgl is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

cmgl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cmgl; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: dxf.hxx,v 1.2 2006/01/02 22:29:15 zeldan Exp $

#ifndef CMGL_DXF_HXX
#define CMGL_DXF_HXX

#include <comf/object.hxx>
#include <comf/types.hxx>
#include <comf/text.hxx>

#include "types.hxx"

CMGL_NS_BEGIN

class Dxf : comf::Entity
{

	public:
	Dxf(comf::TextOutput & text, double scale = 1);
	virtual ~Dxf();

	//TODO void draw(const Polyarc2D &);
	void draw(const Segment2D &);
	void draw(const Circle2D &);
	void draw(const Arc2D &);
	void draw(const Point2D &);
	void draw(const Polygon2D &);
	//TODO void draw(const std::vector<Point2D> &, bool closed);
	void draw(const Ellipse2D &);

	void drawApprox(const Ellipse2D &, size_t);


	protected:
	comf::TextOutput & _text;
	comf::UserObj _text_use;

	const double _scale;
	
	void fileHead();
	void fileTail();
	void polyHead(bool closed);
	void polyTail();

	void writeReal(double);
	void writeAngle(double);
	void writeRatio(double);
	void writeLayer();
	void writeCoord(const Point2D & p, char w);
	void writeVertex(const Point2D & p, double angle);

	void writeln(const char * str) {_text.writeln(str);}
	void writeln(const std::string & str) {_text.writeln(str);}
};

CMGL_NS_END

#endif
