// ---------------------------------------------------------------------------
// CERTI - HLA RunTime Infrastructure
// Copyright (C) 2002  ONERA
//
// This file is part of CERTI-libcerti
//
// CERTI-libcerti is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// CERTI-libcerti is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
//
// $Id: service_type.hh,v 3.0 2002/11/21 01:27:51 breholee Exp $
// ---------------------------------------------------------------------------

// $Id: service_type.hh,v 3.0 2002/11/21 01:27:51 breholee Exp $

#ifndef _CERTI_SERVICE_TYPE_HH
#define _CERTI_SERVICE_TYPE_HH

#define MAX_EXCEPTION_REASON_LENGTH 100

// Each time a new exception is added, please handle this new one
// in libRTI.cc

namespace certi {

typedef enum {

  // gestion federation
  CREATE_FEDERATION_EXECUTION = 1, 
  DESTROY_FEDERATION_EXECUTION, 
  JOIN_FEDERATION_EXECUTION, 
  RESIGN_FEDERATION_EXECUTION, 
  REQUEST_PAUSE, 
  INITIATE_PAUSE, 
  PAUSE_ACHIEVED, 
  REQUEST_RESUME, 
  INITIATE_RESUME, 
  RESUME_ACHIEVED, 
  REQUEST_FEDERATION_SAVE, 
  INITIATE_FEDERATE_SAVE, 
  FEDERATE_SAVE_BEGUN, 
  FEDERATE_SAVE_ACHIEVED, 
  FEDERATE_SAVE_NOT_ACHIEVED, 
  REQUEST_RESTORE, 
  INITIATE_RESTORE, 
  RESTORE_ACHIEVED, 
  RESTORE_NOT_ACHIEVED, 

  // Declaration
  PUBLISH_OBJECT_CLASS, 
  UNPUBLISH_OBJECT_CLASS, 
  PUBLISH_INTERACTION_CLASS, 
  UNPUBLISH_INTERACTION_CLASS, 
  SUBSCRIBE_OBJECT_CLASS_ATTRIBUTE, 
  UNSUBSCRIBE_OBJECT_CLASS_ATTRIBUTE, 
  SUBSCRIBE_INTERACTION_CLASS, 
  UNSUBSCRIBE_INTERACTION_CLASS, 
  START_REGISTRATION_FOR_OBJECT_CLASS, 
  STOP_REGISTRATION_FOR_OBJECT_CLASS, 
  TURN_INTERACTIONS_ON, 
  TURN_INTERACTIONS_OFF, 

  // Object
  REQUEST_ID, 
  REGISTER_OBJECT, 
  UPDATE_ATTRIBUTE_VALUES, 
  DISCOVER_OBJECT, 
  REFLECT_ATTRIBUTE_VALUES, 
  SEND_INTERACTION, 
  RECEIVE_INTERACTION, 
  DELETE_OBJECT, 
  REMOVE_OBJECT, 
  CHANGE_ATTRIBUTE_TRANSPORT_TYPE, 
  CHANGE_ATTRIBUTE_ORDER_TYPE, 
  CHANGE_INTERACTION_TRANSPORT_TYPE, 
  CHANGE_INTERACTION_ORDER_TYPE, 
  REQUEST_OBJECT_ATTRIBUTE_VALUE_UPDATE, 
  REQUEST_CLASS_ATTRIBUTE_VALUE_UPDATE, 
  PROVIDE_ATTRIBUTE_VALUE_UPDATE, 
  RETRACT, 
  REFLECT_RETRACTION, 

  // Ownership
  REQUEST_ATTRIBUTE_OWNERSHIP_DIVESTITURE, 
  REQUEST_ATTRIBUTE_OWNERSHIP_ASSUMPTION, 
  NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE, 
  ATTRIBUTE_OWNERSHIP_DIVESTITURE_NOTIFICATION, 
  ATTRIBUTE_OWNERSHIP_ACQUISITION_NOTIFICATION, 
  REQUEST_ATTRIBUTE_OWNERSHIP_ACQUISITION, 
  REQUEST_ATTRIBUTE_OWNERSHIP_RELEASE, 
  QUERY_ATTRIBUTE_OWNERSHIP, 
  INFORM_ATTRIBUTE_OWNERSHIP, 
  IS_ATTRIBUTE_OWNED_BY_FEDERATE, 
  ATTRIBUTE_IS_NOT_OWNED, 
  ATTRIBUTE_OWNERSHIP_ACQUISITION_IF_AVAILABLE, 
  ATTRIBUTE_OWNERSHIP_UNAVAILABLE, 
  UNCONDITIONAL_ATTRIBUTE_OWNERSHIP_DIVESTITURE, 
  ATTRIBUTE_OWNERSHIP_ACQUISITION, 
  CANCEL_NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE, 
  ATTRIBUTE_OWNERSHIP_RELEASE_RESPONSE, 
  CANCEL_ATTRIBUTE_OWNERSHIP_ACQUISITION, 
  CONFIRM_ATTRIBUTE_OWNERSHIP_ACQUISITION_CANCELLATION, 
 
  // Time
  REQUEST_FEDERATION_TIME, 
  REQUEST_LBTS, 
  REQUEST_FEDERATE_TIME, 
  REQUEST_MIN_NEXT_EVENT_TIME, 
  SET_LOOKAHEAD, 
  REQUEST_LOOKAHEAD, 
  TIME_ADVANCE_REQUEST, 
  NEXT_EVENT_REQUEST, 
  FLUSH_QUEUE_REQUEST, 
  TIME_ADVANCE_GRANT, 

  // Data Distribution
  CREATE_UPDATE_REGION, 
  CREATE_SUBSCRIPTION_REGION, 
  ASSOCIATE_UPDATE_REGION, 
  DISASSOCIATE_UPDATE_REGION, 
  CHANGE_THRESHOLDS, 
  MODIFY_REGION, 
  DELETE_REGION, 

  // Support Services
  GET_OBJECT_CLASS_HANDLE, 
  GET_OBJECT_CLASS_NAME, 
  GET_ATTRIBUTE_HANDLE, 
  GET_ATTRIBUTE_NAME, 
  GET_INTERACTION_CLASS_HANDLE, 
  GET_INTERACTION_CLASS_NAME, 
  GET_PARAMETER_HANDLE, 
  GET_PARAMETER_NAME, 
  GET_SPACE_HANDLE, 
  GET_SPACE_NAME, 
  GET_FEDERATE_HANDLE, 
  GET_FEDERATE_NAME, 
  SET_TIME_REGULATING, 
  SET_TIME_CONSTRAINED, 
  TICK_REQUEST
 
} TypeService;

}

#endif // _CERTI_SERVICE_TYPE_HH

// $Id: service_type.hh,v 3.0 2002/11/21 01:27:51 breholee Exp $

