// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*- 
// $Id: Fed.hh,v 1.2 2003/03/24 17:54:25 breholee Exp $

#ifndef FED_HH
#define FED_HH

#include <config.h>
#include "Federation.hh"
#include "Federate.hh"
#include "RTI.hh"

class Federate ;

class Fed : public FederateAmbassador
{ 
public:
    char CurrentPauseLabel[100] ;

private:
    RTI::RTIambassador* rtiamb ;
    bool granted ;
    int id ;
    bool verbose ;

    Federate* federate ;
    Federation* federation ;

public:
    Fed(RTI::RTIambassador*, Federate*, Federation*);
    virtual ~Fed();

    void setVerbose(bool);

    // ===== FederateAmbassador =============================================
public:
    void announceSynchronizationPoint(const char *label, const char *tag) 
        throw(FederateInternalError);

    void synchronizationPointRegistrationSucceeded(const char *label) 
        throw(FederateInternalError);

    void synchronizationPointRegistrationFailed(const char *label) 
        throw(FederateInternalError);

    void federationSynchronized(const char *label)
        throw(FederateInternalError);

    void removeObjectInstance(ObjectHandle theObject, 
                              const FedTime& theTime, 
                              const char* theTag, 
                              EventRetractionHandle theHandle) 
        throw(ObjectNotKnown, InvalidFederationTime, FederateInternalError) ;

    void timeAdvanceGrant(const FedTime& theTime) 
        throw(InvalidFederationTime, 
              TimeAdvanceWasNotInProgress, 
              FederationTimeAlreadyPassed, 
              FederateInternalError);

    void startRegistrationForObjectClass(ObjectClassHandle theClass)
        throw(ObjectClassNotPublished, FederateInternalError);

    void stopRegistrationForObjectClass(ObjectClassHandle theClass)
        throw(ObjectClassNotPublished, FederateInternalError);

    void turnInteractionsOn(InteractionClassHandle theHandle) 
        throw(InteractionClassNotPublished, FederateInternalError);

    void turnInteractionsOff(InteractionClassHandle theHandle) 
        throw(InteractionClassNotPublished, FederateInternalError);

    void discoverObjectInstance(ObjectHandle theObject, 
                                ObjectClassHandle theObjectClass, 
                                const char *theObjectName)
        throw(CouldNotDiscover, 
              ObjectClassNotKnown, 
              InvalidFederationTime, 
              FederateInternalError);

    void reflectAttributeValues(ObjectHandle theObject, 
                                const AttributeHandleValuePairSet& theAttributes,
                                const FedTime& theTime, const char *theTag, 
                                EventRetractionHandle theHandle) 
        throw(ObjectNotKnown, 
              AttributeNotKnown, 
              InvalidFederationTime, 
              FederateInternalError);

    void receiveInteraction(InteractionClassHandle theInteraction, 
                            const ParameterHandleValuePairSet& theParameters, 
                            const FedTime& theTime, 
                            const char *theTag, 
                            EventRetractionHandle theHandle) 
        throw(InteractionClassNotKnown, 
              InteractionParameterNotKnown, 
              InvalidFederationTime, 
              FederateInternalError);

    //   void removeObjectInstance(ObjectHandle theObject, 
    // 			    const FedTime& theTime, 
    // 			    const char *theTag, 
    // 			    EventRetractionHandle theHandle) 
    //     throw(ObjectNotKnown, 
    // 	  InvalidFederationTime, 
    // 	  FederateInternalError);

    void timeRegulationEnabled(const FedTime& theTime) 
        throw(InvalidFederationTime, 
              EnableTimeRegulationWasNotPending,
              FederateInternalError);

    Boolean isAttributeOwnedByFederate(ObjectHandle theObject,     
                                       AttributeHandle theAttribute)
        throw(ObjectNotKnown,
              AttributeNotDefined,
              FederateNotExecutionMember,
              ConcurrentAccessAttempted,
              SaveInProgress,
              RestoreInProgress,
              RTIinternalError);
	
    void attributeIsNotOwned(ObjectHandle theObject, AttributeHandle theAttribute)
        throw(ObjectNotKnown, AttributeNotKnown, FederateInternalError);

    void Fed::informAttributeOwnership(ObjectHandle theObject,    
                                       AttributeHandle theAttribute, 
                                       FederateHandle theOwner)     
        throw(ObjectNotKnown, AttributeNotKnown, FederateInternalError);

    void attributeOwnershipUnavailable(ObjectHandle theObject,         
                                       const AttributeHandleSet& offeredAttributes)
        throw(ObjectNotKnown,
              AttributeNotDefined,	
              AttributeAlreadyOwned,
              AttributeAcquisitionWasNotRequested,
              FederateInternalError);	

    void attributeOwnershipAcquisitionNotification(
                                                   ObjectHandle theObject, 
                                                   const AttributeHandleSet& securedAttributes) 
        throw(ObjectNotKnown,
              AttributeNotKnown,
              AttributeAcquisitionWasNotRequested,
              AttributeAlreadyOwned,
              AttributeNotPublished,		
              FederateInternalError);	
 
    void requestAttributeOwnershipAssumption(
                                             ObjectHandle theObject,         
                                             const AttributeHandleSet& offeredAttributes, 
                                             const char *theTag)            
        throw(ObjectNotKnown,
              AttributeNotKnown,
              AttributeAlreadyOwned,
              AttributeNotPublished,
              FederateInternalError);
	
    void attributeOwnershipDivestitureNotification (
                                                    ObjectHandle theObject,
                                                    const AttributeHandleSet& releasedAttributes) 
        throw(ObjectNotKnown,
              AttributeNotKnown,
              AttributeNotOwned,	
              AttributeDivestitureWasNotRequested,	
              FederateInternalError);

    void requestAttributeOwnershipRelease (
                                           ObjectHandle theObject,
                                           const AttributeHandleSet& candidateAttributes,
                                           const char *theTag) 
        throw(ObjectNotKnown,
              AttributeNotKnown,
              AttributeNotOwned,
              FederateInternalError);
	
    void confirmAttributeOwnershipAcquisitionCancellation (
                                                           ObjectHandle theObject,
                                                           const AttributeHandleSet& theAttributes)
        throw(ObjectNotKnown,
              AttributeNotKnown,
              AttributeAlreadyOwned,
              AttributeAcquisitionWasNotCanceled,
              FederateInternalError);		


    // ------ temporaire ---------------------------------------------------------

    virtual void setTAG(bool);  // Time Advance Granted
    virtual bool getTAG(void);
    void setId(int);

};
#endif // FED_HH

// $Id: Fed.hh,v 1.2 2003/03/24 17:54:25 breholee Exp $

