// Generated on 2011 June Thu, 30 at 14:01:31 by the CERTI message generator
#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H
// ****-**** Global System includes ****-****
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <assert.h>
#include <string.h>
// ****-**** Includes coming from native types ****-****

#include "MsgBuffer.h"
// The generated file will be put in 
// the MsgTutorial package
//package MsgTutorial 

   // Native types has been defined:
   //     - by included headers (see above)
   //     - with typedef (see below [if any])

   typedef uint32_t M_Type;

   typedef char* MStreamType;
   //addressbook package equivalent in C
   static const uint32_t addressbook_versionMajor = 1;
   static const uint32_t addressbook_versionMinor = 0;

   typedef enum addressbook_PhoneType {
      MOBILE = 0, 
      HOME, 
      WORK 

   } addressbook_PhoneType; //end of enum PhoneType 



   typedef enum addressbook_MessageType {
      NOT_USED = 0, 
      PERSON, 
      ADDRESSBOOK, 
      LAST 

   } addressbook_MessageType; //end of enum MessageType 

   typedef struct  nmsg {
      uint32_t type;
      char* messageName;
   } nmsg; 

   void nmsg_create();
   void nmsg_destroy();

   void nmsg_serialize(nmsg* cthis, MsgBuffer_t* msgBuffer);
   void nmsg_deserialize(nmsg* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   uint32_t nmsg_getType(nmsg cthis)  {return cthis.type;}
   void nmsg_setType(nmsg* cthis,  uint32_t newType) {cthis->type=newType;}
   char* nmsg_getMessageName(nmsg cthis)  {return cthis.messageName;}
   void nmsg_setMessageName(nmsg* cthis,  char* newMessageName) {cthis->messageName=newMessageName;}
   // the show method
   FILE* show(FILE* out);

   typedef struct  PhoneNumber {
      char* number;
      addressbook_PhoneType type;
      uint8_t _hasType;
   } PhoneNumber; 

   void PhoneNumber_create();
   void PhoneNumber_destroy();

   void PhoneNumber_serialize(PhoneNumber* cthis, MsgBuffer_t* msgBuffer);
   void PhoneNumber_deserialize(PhoneNumber* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   char* PhoneNumber_getNumber(PhoneNumber cthis)  {return cthis.number;}
   void PhoneNumber_setNumber(PhoneNumber* cthis,  char* newNumber) {cthis->number=newNumber;}
   addressbook_PhoneType PhoneNumber_getType(PhoneNumber cthis)  {return cthis.type;}
   void PhoneNumber_setType(PhoneNumber* cthis,  addressbook_PhoneType newType) {
      cthis->_hasType=1;
      cthis->type=newType;
   }
   uint8_t hasType(PhoneNumber cthis) {return cthis._hasType;}
   // the show method
   FILE* show(FILE* out);

   typedef struct  Person{
      nmsg super;
      char* name;
      int32_t id;
      char* email;
      uint8_t _hasEmail;
      PhoneNumber* phone;
      uint32_t phonesize;
   } Person; 

   void Person_create();
   void Person_destroy();

   void Person_serialize(Person* cthis, MsgBuffer_t* msgBuffer);
   void Person_deserialize(Person* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   char* Person_getName(Person cthis)  {return cthis.name;}
   void Person_setName(Person* cthis,  char* newName) {cthis->name=newName;}
   int32_t Person_getId(Person cthis)  {return cthis.id;}
   void Person_setId(Person* cthis,  int32_t newId) {cthis->id=newId;}
   char* Person_getEmail(Person cthis)  {return cthis.email;}
   void Person_setEmail(Person* cthis,  char* newEmail) {
      cthis->_hasEmail=1;
      cthis->email=newEmail;
   }
   uint8_t hasEmail(Person cthis) {return cthis._hasEmail;}
   uint32_t Person_getPhoneSize(Person cthis) { return cthis.phonesize;}
   void Person_setPhoneSize(Person* cthis, uint32_t num) { 
      PhoneNumber* temp;
      temp = calloc(num,sizeof(PhoneNumber));
      memcpy(temp,cthis->phone, cthis->phonesize);
      free(cthis->phone);
      cthis->phone = temp;
      cthis->phonesize = num;
   }
      PhoneNumber Person_getPhone(Person* cthis, uint32_t rank) {return cthis->phone[rank];}
   void Person_setPhone(Person* cthis, PhoneNumber newPhone, uint32_t rank) {cthis->phone[rank]=newPhone;}
   // the show method
   FILE* show(FILE* out);

   typedef struct  AddressBook{
      nmsg super;
      Person* person;
      uint32_t personsize;
   } AddressBook; 

   void AddressBook_create();
   void AddressBook_destroy();

   void AddressBook_serialize(AddressBook* cthis, MsgBuffer_t* msgBuffer);
   void AddressBook_deserialize(AddressBook* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   uint32_t AddressBook_getPersonSize(AddressBook cthis) { return cthis.personsize;}
   void AddressBook_setPersonSize(AddressBook* cthis, uint32_t num) { 
      Person* temp;
      temp = calloc(num,sizeof(Person));
      memcpy(temp,cthis->person, cthis->personsize);
      free(cthis->person);
      cthis->person = temp;
      cthis->personsize = num;
   }
      Person AddressBook_getPerson(AddressBook* cthis, uint32_t rank) {return cthis->person[rank];}
   void AddressBook_setPerson(AddressBook* cthis, Person newPerson, uint32_t rank) {cthis->person[rank]=newPerson;}
   // the show method
   FILE* show(FILE* out);

   /*
   typedef struct  M_Factory {
      public:
         static nmsg* create(M_Type type) throw (string); 
      protected:
      private:
   };

   */
// end of namespace MsgTutorial 
// ADDRESSBOOK_H
#endif
