#!/bin/sh

#
# mkpolicy 0.0.1r1  -  utility to convert release specific aaa_base.tar.gz
#                      file into a useful policy file
#

if test "$1" != ""; then
  CPWD="`pwd`"
  T="`mktemp /tmp/tmp.XXXXXX`"

  rm -f $T

  echo

  echo "#"
  echo "#"
  echo "#"

  echo

  echo "DIRECTORY_POLICY ()"
  echo "{"
  echo "  if test \"\$DESTDIR\" != \"\"; then"

  mkdir -p $T && cd $T && tar xfzp ${CPWD}/$1
  rm -rf ./install
  find . -type d -printf "    if test -d %p; then ( chown %u:%g %p && chmod %m %p ); fi\n" | grep -v " \. " | sed s/\\\.\\\//\\\${DESTDIR}\\\//g
  cd $CPWD && rm -rf $T
  
  echo "  fi"
  echo "}"
  
  echo
  
  echo "FILE_POLICY ()"
  echo "{"
  echo "  return 0"
  echo "}"
else
  echo "usage: $0 aaa_base.tar.gz"
fi
