#!/bin/sh

if test "$1" = ""; then
  echo "usage: $0 listfile"
  exit
fi

echo "#"
echo "# -----------------------------------------------------------------------------"
echo "# 'buildpkg.jail' generated by generate_jail.sh"
echo "# -----------------------------------------------------------------------------"
echo "#"
echo "# <begin>"

for f_name in `cat $1`; do
  if test "`basename $f_name`" = "$f_name"; then
    ff_name="`PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin which $f_name 2>/dev/null`"
    if test $? -eq 1 -o "`echo $ff_name | cut -d' ' -f1-3`" = "no $f_name in"; then
      echo "# '"$f_name"' not found"
      continue
    fi
    f_name="$ff_name"
  fi

  ff_name=""

  for ff_name in `ls $f_name 2>/dev/null`; do
    echo $ff_name
  done

  if test "$ff_name" = ""; then
    echo "# '"$f_name"' not found"
  fi
done

echo "# <end>"
