/*
 * $Id: lstat.c,v 1.1 2003/05/10 10:43:38 dice Exp $
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

int QUIET = 0;

int main (int argc, char **argv)
{
  struct stat buf;
  int argnum = 1;

  if (argc > 1)
  {
    if (!strcmp(argv[argnum], "-q"))
    {
      QUIET = 1;
      argnum ++;
    }

    if (!lstat(argv[argnum], &buf))
    {
      printf ("%s - %ld - %ld\n", argv[argnum], buf.st_mtime, buf.st_size);
    } else {
      if (!QUIET) perror ("ERROR");
    }
  } else {
    printf ("usage: lstat [-q] filename\n");
  }

  return 0;
}
