#define LASCA   0
#define MHI     1
#define REGIOES 2
#define CAMERA  3

#define SAVE_VIDEO_MODE 2
#define SAVE_IMAGE_MODE 1
#define CAMERA_MODE 0

#define NORMAL_CAMERA 0
#define GRAY_CAMERA   1
#define COLOR_CAMERA  2

#include <QFileDialog>
#include <QDir>
#include "extras.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"

#ifndef CV_WINDOW_NORMAL
    #define CV_WINDOW_NORMAL   0x00000000 //the user can resize the window (no constraint)  / also use to switch a fullscreen window to a normal size
#endif

#ifndef CV_WINDOW_AUTOSIZE
    #define CV_WINDOW_AUTOSIZE 0x00000001 //the user cannot resize the window, the size is constrainted by the image displayed
#endif

#ifndef cvCopyImage
    #define cvCopyImage cvCopy
#endif
#ifndef cvQueryHistValue_1D
    #define cvQueryHistValue_1D cvGetReal1D
#endif

#include <QMessageBox>
#include <QSettings>
#ifdef __OS_UNIX__ 
char qtdefault[] = "qualitytest";
#endif
#ifdef __OS_WINDOWS__ 
char qtdefault[] = "C:\\Program Files (x86)\\QualityTest\\bin\\qualitytest.exe";
#endif

/* ****************************** Interface ********************************* */

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    char *PROGRAM_DIR=get_absolute_speckle_tool_path();
    //qWarning()<<PROGRAM_DIR<<endl;
    setWindowIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/camera.png"));
    setWindowTitle("Speckle Tool "+QString(APP_VERSION));

    algorhitm_selected_execute = CAMERA;
    selected_image_camera = NORMAL_CAMERA;
    selected_camera = 0;
    camOn = false;
    saveMode = false;
    firstTime = true;
    mhiObj=NULL;
    lastT=0.0;
    lastT0=0.0;
    sisObj=NULL;
    fd_time=NULL;

    ui->action_Open                 ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/document-open.png"));
    ui->action_Salve_Video          ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/document-save.png"));
    ui->action_Salve_Image_Sequence ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/document-save-as.png"));
    ui->actionSobre                 ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/help-about.png"));
    ui->actionDocumentation         ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/help-about.png"));
    ui->actionManual                ->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/document-save.png"));
    ui->actionConfiguracao_da_Camera->setIcon(QIcon(QString(PROGRAM_DIR)+"../share/speckletool/icons/document-properties.png"));

    connect(ui->action_Open                , SIGNAL(triggered()), this, SLOT(openFile()));
    connect(ui->action_Salve_Video         , SIGNAL(triggered()), this, SLOT(saveVideo()));
    connect(ui->action_Salve_Image_Sequence, SIGNAL(triggered()), this, SLOT(saveImageSequence()));
    connect(ui->action_primaria            , SIGNAL(triggered()), this, SLOT(camera_first()));
    connect(ui->action_secundaria          , SIGNAL(triggered()), this, SLOT(camera_second()));
    connect(ui->actionSobre                , SIGNAL(triggered()), this, SLOT(sobre()));
    connect(ui->actionDocumentation        , SIGNAL(triggered()), this, SLOT(open_documentation()));

    ui->lineEdit_filenameqt->setText(qtdefault);
    load_init_file();
}

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::load_init_file(void)
{
    QSettings settings("speckletool","speckletool");
    QString str=settings.value("mydata/qualitytestpath",qtdefault).toString();
    printf("qualitytestpath=%s\n",str.toLocal8Bit().data());
    printf("Read data from:%s\n",settings.fileName().toLocal8Bit().data());

    ui->lineEdit_filenameqt->setText(str);
}

void MainWindow::save_init_file(QString str)
{
    QSettings settings("speckletool","speckletool");
    settings.beginGroup("mydata");
    settings.setValue("qualitytestpath",str);
    settings.endGroup();
    //printf("Wrote data in:%s\n",settings.fileName().toLocal8Bit().data());
}

void MainWindow::on_pushButton_pathqt_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Select Images"), NULL,
                                                    tr("Arquivos de Imagem (qualitytest qualitytest.exe)"));

    if(fileName==NULL)  printf("NULL\n");
    else                printf("Loaded: %s\n",fileName.toLocal8Bit().data());

    ui->lineEdit_filenameqt->setText(fileName);
}

#include <QProcess>

void MainWindow::on_pushButton_launchqt_clicked()
{
    QString command = ui->lineEdit_filenameqt->text();
    printf("\nLaunching: %s\n",command.toLocal8Bit().data());

    QProcess * p = new QProcess();

    #ifdef __OS_WINDOWS__
    bool id=p->startDetached("\""+command+"\"");
    #endif

    #ifdef __OS_UNIX__
    bool id=p->startDetached(command);
    #endif

    if(id==0)
    {
        QString mess="Warning the \"" + command + "\" program was not launched.\n";
        mess = mess + "The program is not installed or It was installed but not added to the system PATH.\n"; 
        mess = mess + "Please, try verify the address and later write the complete filename path of qualitytest program.\n";
        #ifdef __OS_UNIX__ 
        mess = mess + "Example: /complete/route/of/qualitytest\n\n";
        #endif
        #ifdef __OS_WINDOWS__ 
        mess = mess + "Example: c:\\complete\\route\\of\\qualitytest.exe.\n\n";
        #endif

        printf("%s",mess.toLocal8Bit().data());

        QMessageBox *msgBox = new QMessageBox(this);
        msgBox->setText(mess);
        msgBox->setWindowTitle("Warning!!!");
        msgBox->setIcon(QMessageBox::Warning);
        msgBox->setWindowModality(Qt::ApplicationModal);
        msgBox->exec();

    }
    else
    {
        save_init_file(command);
        printf("Launched");
    }

}

void MainWindow::on_threshould_mhi_horizontalSlider_valueChanged(int value)
{
    ui->threshold_mhi_value_label->setText(QString::number(value));
}

void MainWindow::on_mask_lasca_spinBox_valueChanged(int value)
{
    ui->step_lasca_spinBox->setMaximum(value);
    if(ui->lock_lasca_checkBox->isChecked() ||
       ui->step_lasca_spinBox->value() > value)
    {
        ui->step_lasca_spinBox->setValue(value);
    }
}

void MainWindow::on_threshold_regions_horizontalSlider_valueChanged(int value)
{
    ui->threshold_regions_value_label->setText(QString::number(value));
}

void MainWindow::on_lock_lasca_checkBox_stateChanged(int value)
{
    ui->step_lasca_spinBox->setEnabled(!value);
    if(value)
        ui->step_lasca_spinBox->setValue(ui->mask_lasca_spinBox->value());
}

void MainWindow::on_cam_pushButton_clicked()
{
    camOn = !camOn;
    mode = CAMERA_MODE;

    if(camOn)
    {
        ui->cam_pushButton->setText("OFF");
        ui->menuSelecionar_camera->setEnabled(false);

        start_processing();

        if(ui->histogram_checkBox->isChecked())
        {
            cvNamedWindow("Histogram",CV_WINDOW_NORMAL);
            cvMoveWindow("Histogram", 40, 435);
        }

        if(ui->processing_checkBox->isChecked())
        {

            switch(algorhitm_selected_execute)
            {
                case LASCA:
                    cvNamedWindow("LASCA", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("LASCA", 435, 0);
                    break;
                case MHI:
                    cvNamedWindow("MHI", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("MHI", 435, 0);
                    break;
                case REGIOES:
                    cvNamedWindow("Regions", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("Regions", 435, 0);
                    break;
                case CAMERA:
                    cvNamedWindow("Camera", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("Camera", 435, 0);
                    break;
            }

        }

    } else {
        stop_processing();
        ui->cam_pushButton->setText("ON");
        ui->menuSelecionar_camera->setEnabled(true);
        cvDestroyWindow("Histogram");
        switch(algorhitm_selected_execute)
        {
        case LASCA:
            cvDestroyWindow("LASCA");
            break;
        case MHI:
            cvDestroyWindow("MHI");
            break;
        case REGIOES:
            cvDestroyWindow("Regions");
            break;
        case CAMERA:
            cvDestroyWindow("Camera");
            break;
        }
        firstTime = true;
        ui->tabWidget->setCurrentIndex(0);
    }

}

void MainWindow::on_histogram_checkBox_stateChanged(int value)
{
    if(value && camOn)
    {
        cvNamedWindow("Histogram", CV_WINDOW_NORMAL);
        cvMoveWindow("Histogram", 40, 435);
    }else
    {
        cvDestroyWindow("Histogram");
    }
}

void MainWindow::on_processing_checkBox_stateChanged(int value)
{
    if(value && camOn)
    {

        switch(algorhitm_selected_execute)
        {
            case LASCA:
                cvNamedWindow("LASCA", CV_WINDOW_AUTOSIZE);
                cvMoveWindow("LASCA", 435, 0);
                break;
            case MHI:
                cvNamedWindow("MHI", CV_WINDOW_AUTOSIZE);
                cvMoveWindow("MHI", 435, 0);
                break;
            case REGIOES:
                cvNamedWindow("Regions", CV_WINDOW_AUTOSIZE);
                cvMoveWindow("Regions", 435, 0);
                break;
            case CAMERA:
                cvNamedWindow("Camera", CV_WINDOW_AUTOSIZE);
                cvMoveWindow("Camera", 435, 0);
                break;
        }

    } else {
        switch(algorhitm_selected_execute)
        {
        case LASCA:
            cvDestroyWindow("LASCA");
            break;
        case MHI:
            cvDestroyWindow("MHI");
            break;
        case REGIOES:
            cvDestroyWindow("Regions");
            break;
        case CAMERA:
            cvDestroyWindow("Camera");
            break;
        }
    }
}

void MainWindow::on_lasca_execute_radioButton_clicked()
{
    if(ui->processing_checkBox->isChecked() && camOn)
    {
        switch(algorhitm_selected_execute)
        {
        case MHI:
            cvDestroyWindow("MHI");
            break;
        case REGIOES:
            cvDestroyWindow("Regions");
            break;
        case CAMERA:
            cvDestroyWindow("Camera");
            break;
        }
        cvNamedWindow("LASCA", CV_WINDOW_AUTOSIZE);
        cvMoveWindow("LASCA", 435, 0);
        ui->tabWidget->setCurrentIndex(4);
    }
    algorhitm_selected_execute = LASCA;
}

void MainWindow::on_mhi_execute_radioButton_clicked()
{
    if(ui->processing_checkBox->isChecked() && camOn)
    {
        switch(algorhitm_selected_execute)
        {
        case LASCA:
            cvDestroyWindow("LASCA");
            break;
        case REGIOES:
            cvDestroyWindow("Regions");
            break;
        case CAMERA:
            cvDestroyWindow("Camera");
            break;
        }
        cvNamedWindow("MHI", CV_WINDOW_AUTOSIZE);
        cvMoveWindow("MHI", 435, 0);
        ui->tabWidget->setCurrentIndex(3);
    }
    algorhitm_selected_execute = MHI;
}

void MainWindow::on_regions_execute_radioButton_clicked()
{
    if(ui->processing_checkBox->isChecked() && camOn)
    {
        switch(algorhitm_selected_execute)
        {
        case LASCA:
            cvDestroyWindow("LASCA");
            break;
        case MHI:
            cvDestroyWindow("MHI");
            break;
        case CAMERA:
            cvDestroyWindow("Camera");
            break;
        }
        cvNamedWindow("Regions", CV_WINDOW_AUTOSIZE);
        cvMoveWindow("Regions", 435, 0);
        ui->tabWidget->setCurrentIndex(2);
    }
    algorhitm_selected_execute = REGIOES;
}

void MainWindow::on_camera_execute_radioButton_clicked()
{
    if(ui->processing_checkBox->isChecked() && camOn)
    {
        switch(algorhitm_selected_execute)
        {
        case LASCA:
            cvDestroyWindow("LASCA");
            break;
        case MHI:
            cvDestroyWindow("MHI");
            break;
        case REGIOES:
            cvDestroyWindow("Regions");
            break;
        }
        cvNamedWindow("Camera", CV_WINDOW_AUTOSIZE);
        cvMoveWindow("Camera", 435, 0);
        ui->tabWidget->setCurrentIndex(1);
    }
    algorhitm_selected_execute = CAMERA;
}

void MainWindow::on_normal_image_camera_radioButton_clicked()
{
    selected_image_camera = NORMAL_CAMERA;
}

void MainWindow::on_gray_imagem_camera_radioButton_clicked()
{
    selected_image_camera = GRAY_CAMERA;
}

void MainWindow::on_color_image_camera_radioButton_clicked()
{
    selected_image_camera = COLOR_CAMERA;
}

void MainWindow::on_nFrames_spinBox_valueChanged(int value)
{
    if(camOn)
        instantiate_mhiObj(value);


    if(ui->automatic_duration_mhi_checkBox->isChecked())
        ui->mhi_duration_doubleSpinBox->setValue((double)value /
                                                 ui->fps_spinBox->value());
}

void MainWindow::on_automatic_duration_mhi_checkBox_stateChanged(int value)
{
    ui->mhi_duration_doubleSpinBox->setEnabled(!value);
    if(value)
        ui->mhi_duration_doubleSpinBox->setValue((double)
                                                 ui->nFrames_spinBox->value() /
                                                 ui->fps_spinBox->value());
}

void MainWindow::on_fps_spinBox_valueChanged(int value)
{
    if(ui->automatic_duration_mhi_checkBox->isChecked())
        ui->mhi_duration_doubleSpinBox->setValue(ui->nFrames_spinBox->value()/
                                                 (double)value);
    if(camOn)
        restart_processing();
}

void MainWindow::openFile()
{
    execute_openFile();
}

void MainWindow::saveVideo()
{
    execute_saveVideo();
}

void MainWindow::saveImageSequence()
{
    execute_saveImageSequence();
}

void MainWindow::camera_first()
{
    selected_camera = 0;
    ui->action_secundaria->setChecked(!ui->action_primaria->isChecked());
}

void MainWindow::camera_second()
{
    selected_camera = 1;
    ui->action_primaria->setChecked(!ui->action_secundaria->isChecked());
}

/* ************************************************************************** */
/* ****************************** Processing ******************************** */
/* ************************************************************************** */

void MainWindow::start_processing()
{
    // Create camera Object.
    cvReleaseCapture(&camera);
    camera = cvCreateCameraCapture(selected_camera);
    assert(camera);//assert will terminate the program if its argument turns out to be false

    mhiObj = new Mhi(ui->nFrames_spinBox->value());
    // Star Timer Event.
    timer = startTimer(1000/ui->fps_spinBox->value());
}

void MainWindow::restart_processing()
{
    killTimer(timer);
    timer = startTimer(1000/ui->fps_spinBox->value());
}

void MainWindow::stop_processing()
{
    delete mhiObj;mhiObj=NULL;
    killTimer(timer);
    cvReleaseCapture(&camera);
    camera=NULL;
}

void MainWindow::timerEvent(QTimerEvent *)
{
    double currentT;

    switch(mode)
    {
        case SAVE_VIDEO_MODE:
        {
            ui->statusBar->showMessage(QString::fromUtf8("Saving video..."));
            IplImage* img = 0;
            if ( count_saveVideo < numImages_SaveVideoMode)
            {
                cvGrabFrame(camera);                  // capture a frame
                img=cvRetrieveFrame(camera);          // retrieve the captured frame
                cvWriteFrame(writer,img);             // add the frame to the file
                count_saveVideo++;
            } else
            {
                cvReleaseImage(&img);
                saveMode = false;
                ui->statusBar->showMessage(QString::fromUtf8("Video saved!"), 5000);
                killTimer(timer_SaveVideoMode);
                cvReleaseVideoWriter(&writer);
                cvReleaseCapture(&camera);
                camera=NULL;
            }            
            break;
        }
        case SAVE_IMAGE_MODE:
        {
            if ( count_saveImg < (numImages_SaveMode))
            {
                if(count_saveImg==0)    
                {
                    filename_time = dirName_SaveMode;
                    filename_time = filename_time.append("/speckletool.time");
                    fd_time=fopen(filename_time.toStdString().c_str(),"w");
                    if(fd_time==NULL)   qWarning()<<"Error creating a 'speckletool.time' file. Possible access error."<<endl
                                                  <<"Are you using the snap version of speckletool program?"<<endl 
                                                  <<"Snaps only can write in the user home directory and subs."<<endl;

                    lastT   = (double)cvGetTickCount();
                    lastT0  = lastT;
                    currentT= lastT;

                }
                else
                {
                    currentT= (double)cvGetTickCount();
                }

                double deltaTsec   = ( currentT - lastT)/(cvGetTickFrequency()*1000.0);
                double currentTsec = ( currentT - lastT0)/(cvGetTickFrequency()*1000.0);
                lastT= currentT;

                if(fd_time!=NULL)
                    fprintf(fd_time,"%d\t%f\t%f\n",count_saveImg,currentTsec,deltaTsec);
                if (count_saveImg==(numImages_SaveMode-1))  
                    {fclose(fd_time);fd_time=NULL;}

                imgCam = cvQueryFrame(camera);
                imgCamGray = cvCreateImage(cvGetSize(imgCam), 8, 1);
                cvCvtColor(imgCam, imgCamGray, CV_RGB2GRAY);

                switch(algorhitm_selected_execute)
                {
                    case LASCA:
                        execute_lasca(imgCamGray);
                        break;
                    case MHI:
                        execute_mhi(imgCam);
                        break;
                    case REGIOES:
                        execute_regions(imgCam, imgCamGray);
                        break;
                    case CAMERA:
                        execute_camera(imgCam, imgCamGray);
                        break;
                 }
                count_saveImg++;



                cvReleaseImage(&imgCamGray);

            } else
            {
                killTimer(timer_SaveImgMode);
                cvReleaseCapture(&camera);
                camera=NULL;
                saveMode=false;
                count_saveImg = 0;
                ui->statusBar->showMessage( QString::fromUtf8("Images Saved successfully!"),5000);
            }

            break;
        }
        case CAMERA_MODE:
        {
            double tempo = (double)cvGetTickCount();

            // Check to create the camera image.
            if( ui->histogram_checkBox->isChecked() || ui->processing_checkBox->isChecked() )
                imgCam = cvQueryFrame(camera);



            if(!imgCam)
            {
                if (ui->action_Opened_Video_Mode_Repeat->isChecked() && openedVideoMode)
                {
                    // reinstantieate the camera object with the video filename.
                    camera = cvCaptureFromFile(fileName.toLocal8Bit().data());
                } else
                {
                    openedVideoMode = false;
                    camOn = !camOn;
                    killTimer(timer);
                    fileName.clear();
                    switch(algorhitm_selected_execute)
                    {
                    case LASCA:
                        cvDestroyWindow("LASCA");
                        break;
                    case MHI:
                        cvDestroyWindow("MHI");
                        break;
                    case REGIOES:
                        cvDestroyWindow("Regions");
                        break;
                    case CAMERA:
                        cvDestroyWindow("Camera");
                        break;
                    }
                    cvDestroyWindow("Histogram");
                    ui->tabWidget->setCurrentIndex(0);
                    ui->statusBar->showMessage(QString::fromUtf8
                                                  ("Finished Executing the Video"),
                                                  5000);
                }
            }
            else
            {
                imgCamGray = cvCreateImage(cvGetSize(imgCam), 8, 1);
                cvCvtColor(imgCam, imgCamGray, CV_RGB2GRAY);

                 // Check to create and exhibit the image histogram.
                if(ui->histogram_checkBox->isChecked())
                {
                    IplImage *imgHist = auxImagemObj->histogram(imgCamGray);
                    cvShowImage("Histogram", imgHist);
                    cvReleaseImage(&imgHist);
                }

                if(ui->processing_checkBox->isChecked())
                {

                    switch(algorhitm_selected_execute)
                    {
                        case LASCA:
                            execute_lasca(imgCamGray);
                            break;
                        case MHI:
                            execute_mhi(imgCam);
                            break;
                        case REGIOES:
                            execute_regions(imgCam, imgCamGray);
                            break;
                        case CAMERA:
                            execute_camera(imgCam, imgCamGray);
                            break;
                        }

                    if(firstTime)
                    {
                        ui->tabWidget->setCurrentIndex(4 - algorhitm_selected_execute);
                        firstTime = false;
                    }

                }

                cvReleaseImage(&imgCamGray);

                tempo = ((double)cvGetTickCount() - tempo)/
                        (cvGetTickFrequency()*1000.0);

                if(ui->actionMostrar_Mensagem_de_Sobrecarga_do_sistema->isChecked())
                {
                    if(tempo > (1000/ui->fps_spinBox->value()))
                        ui->statusBar->showMessage("Warning: System Overhead!");
                    else
                        ui->statusBar->showMessage("");
                }

            }
            break;
        }
    }

}

void MainWindow::execute_lasca(IplImage *image)
{
    if(ui->color_lasca_checkBox->isChecked())
    {
        IplImage* imgLasca = lascaObj->calcLasca(image,
                                               ui->mask_lasca_spinBox->value(),
                                               ui->step_lasca_spinBox->value());
        IplImage* imgColorLasca = auxImagemObj->coloreImagem(imgLasca);

        if(saveMode)
        {
            QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
            QString name = dirName_SaveMode;
            name = name.append(aux);
            cvSaveImage(name.toLocal8Bit().data(), imgColorLasca);

        }
        else
            cvShowImage("LASCA", imgColorLasca);

        cvReleaseImage(&imgLasca);
        cvReleaseImage(&imgColorLasca);
    }

    else
    {
        IplImage* imgLasca = lascaObj->calcLasca(image,
                                               ui->mask_lasca_spinBox->value(),
                                               ui->step_lasca_spinBox->value());

        if(saveMode)
        {
            QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);

            QString name = dirName_SaveMode;
            name = name.append(aux);
            cvSaveImage(name.toLocal8Bit().data(), imgLasca);
        }
        else
            cvShowImage("LASCA", imgLasca);

        cvReleaseImage(&imgLasca);
    }
}

void MainWindow::execute_mhi(IplImage *image)
{
    IplImage* mhi_color = cvCreateImage(cvGetSize(image), 8, 3);
    IplImage* mhi_gray = cvCreateImage(cvGetSize(image), 8, 1);

    mhiObj->update_mhi(image, mhi_color, mhi_gray,
                       255-ui->threshould_mhi_horizontalSlider->value(),
                       ui->mhi_duration_doubleSpinBox->value());

    if(ui->color_mhi_checkBox->isChecked())
    {
        if(saveMode)
        {
            QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
            QString name = dirName_SaveMode;
            name = name.append(aux);
            cvSaveImage(name.toLocal8Bit().data(), mhi_color);
        }
        else
            cvShowImage("MHI", mhi_color);
    }
    else
    {
        if(saveMode)
        {
            QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
            QString name = dirName_SaveMode;
            name = name.append(aux);
            cvSaveImage(name.toLocal8Bit().data(), mhi_gray);
        }
        else
            cvShowImage("MHI", mhi_gray);
    }
    cvReleaseImage(&mhi_color);
    cvReleaseImage(&mhi_gray);
}

void MainWindow::execute_regions(IplImage *colorImage, IplImage *grayImage)
{
    if(ui->mhi_regions_checkBox->isChecked())
    {
        IplImage* aux = cvCreateImage(cvGetSize(colorImage), 8, 3);
        mhiObj->update_mhi(colorImage, aux, grayImage,
                           255-ui->threshould_mhi_horizontalSlider->value(),
                           ui->mhi_duration_doubleSpinBox->value());
        cvReleaseImage(&aux);
    }

    if(ui->lasca_regions_checkBox->isChecked())
        grayImage = lascaObj->calcLasca(grayImage,
                                        ui->mask_lasca_spinBox->value(),
                                        ui->step_lasca_spinBox->value());

    cvSmooth(grayImage, grayImage, CV_BLUR,
             (ui->radio_blur_regions_spinBox->value() * 2 + 1),
             (ui->radio_blur_regions_spinBox->value() * 2 + 1), 0, 0);

    cvThreshold(grayImage, grayImage,
                ui->threshold_regions_horizontalSlider->value(),
                255, CV_THRESH_BINARY);

    cvCanny(grayImage, grayImage, 100, 200, 3);

    cvNot(grayImage, grayImage);
    cvErode(grayImage, grayImage, NULL, ui->width_line_spinBox->value());

    IplImage* aux = cvCreateImage(cvGetSize(grayImage), 8, 3);
    cvCvtColor(grayImage, aux, CV_GRAY2RGB);

    IplImage* aux1 = cvCreateImage(cvGetSize(colorImage), 8, 3);
    cvResize(aux, aux1);

    IplImage* auxGray = cvCreateImage(cvGetSize(colorImage), 8, 3);
    cvCopyImage(aux1, auxGray);

    cvAnd(aux1, colorImage, aux1);

    if(!ui->sobrepor_regioes_checkBox->isChecked())
    {
        //aux1 = auxGray;
        cvCopy(auxGray, aux1);
        cvNot(aux1, aux1);
    }

    if(saveMode)
    {
        QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
        QString name = dirName_SaveMode;
        name = name.append(aux);
        cvSaveImage(name.toLocal8Bit().data(), aux1);
    }
    else
        cvShowImage("Regions", aux1);

    cvReleaseImage(&aux);
    cvReleaseImage(&aux1);
    cvReleaseImage(&auxGray);
}

void MainWindow::execute_camera(IplImage *colorImage, IplImage *grayImage)
{
    switch(selected_image_camera)
    {
        case NORMAL_CAMERA:
            if(saveMode)
            {
                QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
                QString name = dirName_SaveMode;
                name = name.append(aux);
                cvSaveImage(name.toLocal8Bit().data(), colorImage);
            }
            else
                cvShowImage("Camera", colorImage);
            break;
        case GRAY_CAMERA:
            if(saveMode)
            {
                QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
                QString name = dirName_SaveMode;
                name = name.append(aux);
                cvSaveImage(name.toLocal8Bit().data(), grayImage);
            }
            else
                cvShowImage("Camera", grayImage);
            break;
        case COLOR_CAMERA:
            IplImage* imgColor = auxImagemObj->coloreImagem(grayImage);
            if(saveMode)
            {
                QString aux = "";   aux.sprintf("/%d.bmp",count_saveImg);
                QString name = dirName_SaveMode;
                name = name.append(aux);
                cvSaveImage(name.toLocal8Bit().data(), imgColor);
            }
            else
                cvShowImage("Camera", imgColor);

            cvReleaseImage(&imgColor);
            break;
    }
}

void MainWindow::instantiate_mhiObj(int newValue)
{
    delete mhiObj;
    mhiObj = new Mhi(newValue);
}

void MainWindow::execute_openFile()
{
    fileName = QFileDialog::getOpenFileName(
                                           this,
                                           tr("Open Video"),
                                           QDir::currentPath(),
                                           tr("Videos file (*.avi)"));

    if(!fileName.isNull())
    {
        camera = cvCaptureFromFile(fileName.toLocal8Bit().data());

        assert(camera);
        mode = CAMERA_MODE;
        camOn = true;
        openedVideoMode = true;
        mhiObj = new Mhi(ui->nFrames_spinBox->value());
        timer = startTimer(1000/ui->fps_spinBox->value());

        if(ui->histogram_checkBox->isChecked())
        {
            cvNamedWindow("Histogram", CV_WINDOW_NORMAL);
            cvMoveWindow("Histogram", 40, 435);
        }

        if(ui->processing_checkBox->isChecked())
        {
            switch(algorhitm_selected_execute)
            {
                case LASCA:
                    cvNamedWindow("LASCA", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("LASCA", 435, 0);
                    break;
                case MHI:
                    cvNamedWindow("MHI", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("MHI", 435, 0);
                    break;
                case REGIOES:
                    cvNamedWindow("Regions", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("Regions", 435, 0);
                    break;
                case CAMERA:
                    cvNamedWindow("Camera", CV_WINDOW_AUTOSIZE);
                    cvMoveWindow("Camera", 435, 0);
                    break;
            }
        }
    }
}

void MainWindow::execute_saveVideo()
{

    svObj = new SaveVideoInterface(this);

    if(svObj->exec())
    {

        if(camOn)
            on_cam_pushButton_clicked();

        cvReleaseCapture(&camera);
        camera = cvCreateCameraCapture(selected_camera);
        assert(camera);//assert will terminate the program if its argument turns out to be false

        int fps = svObj->getFPS();
        QString file = svObj->getFileName();

        writer = cvCreateVideoWriter(file.toLocal8Bit().data(),
                                     CV_FOURCC('D','I','V','X'),//CV_FOURCC('M','J','P','G')
                                     fps,cvSize(640, 480));

        count_saveVideo = 0;
        numImages_SaveVideoMode = svObj->getTime() * fps;
        mode = SAVE_VIDEO_MODE;

        timer_SaveVideoMode = startTimer(1000/fps);

    }

    delete svObj;
}

void MainWindow::execute_saveImageSequence()
{
    sisObj = new SaveImageSequenceInterface(this);

    if(sisObj==NULL)    qWarning()<<"SaveImageSequenceInterface(this); return NULL"<<endl;

    if (sisObj->exec())
    {
        if(camOn)
            on_cam_pushButton_clicked();

        saveMode = true;
        dirName_SaveMode   = sisObj->getLocation();
        numImages_SaveMode = sisObj->getNumImage();

        cvReleaseCapture(&camera);
        camera = cvCreateCameraCapture(selected_camera);
        assert(camera);//assert will terminate the program if its argument turns out to be false

        mode = SAVE_IMAGE_MODE;
        count_saveImg = 0;
        timer_SaveImgMode = startTimer(1000/ui->fps_spinBox->value());
        ui->statusBar->showMessage(QString::fromUtf8("Saving Images, wait..."));


    }

    if((algorhitm_selected_execute == MHI || algorhitm_selected_execute == REGIOES)  && !camOn)
    {
        instantiate_mhiObj(ui->nFrames_spinBox->value());
    }
    delete sisObj; sisObj=NULL;
}

void MainWindow::sobre()
{
    sobreObj = new DialogSobre(this);
    sobreObj->exec();
}

void MainWindow::open_documentation()
{
    char *CMD=NULL;
    int ID=0;
    char *PROGRAM_DIR=get_absolute_speckle_tool_path();

    CMD=(char*)calloc(strlen(PROGRAM_DIR)+128,sizeof(char));
#ifdef __OS_UNIX__
    sprintf(CMD,"xdg-open \"file://%s../share/doc/speckletool/SpeckleTool-UserGuide.pdf\" ",PROGRAM_DIR);
#endif

#ifdef __OS_WINDOWS__
    sprintf(CMD,"start \"\" \"%s..\\share\\doc\\speckletool\\SpeckleTool-UserGuide.pdf\" ",PROGRAM_DIR);
#endif
    ID=system(CMD);

    printf("[%d]\t%s\n",ID,CMD);
}
