#ifndef EXTRAS_H
#define EXTRAS_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/** \fn char pds_filesep(void)
 *  \brief Retorna um caracter con el separador de archivo para el sistema.
 *  \return Retorna um caracter con el separador de archivo para el sistema.
 *  En caso de error de dedución, retorna '/' por defecto.
 *  \ingroup PdsFilesFuncGroup
 */
char pds_filesep(void);

/** \fn char *pds_get_dirname(const char * file_path)
 *  \brief Obtén el directorio madre desde una ruta de fichero.
 *
 *  Si la ruta de fichero es: /path_to_file/filename.c
 *  La función retorna:       /path_to_file
 *  \param[in] file_path Ruta del fichero a analizar.
 *  \return Retorna una nueva cadena de texto con el directorio madre, o 
 *  NULL en caso de error de reserva de memoria o fihero sin directorio madre.
 *  \ingroup PdsFilesFuncGroup
 */
char *pds_get_dirname(const char * file_path);


char* get_absolute_speckle_tool_path(void);

#endif 
