package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# This file contains formatting functions.
# They would generally follow the following structure:
# sub f_NAME {
#   my $self = shift;
#   my $i = shift;
# ...
#   $self->outputtext(RESULT_TEXT);
# }

sub f_author {
  my $self = shift;
  my $i = shift;

  $self->outputtext($self->formatnames($i));
}

sub f_editor {
  my $self = shift;
  my $i = shift;

  $self->outputtext($self->formatnames($i));
}

sub f_title {
  my $self = shift;
  my $i = shift;

  my $t = $self->getfield('title', 1);

  # make sure it's in the right language
  $t = $self->language($self->{CUREL}->inherit_att('xml:lang'), $t);

  my $type = $self->{CUREL}->tag;

  if ($type eq 'article') {
    $t = $self->applyfont($t, $self->{STYLE}{articlefont});
  } elsif ($type eq 'thesis') {
    $t = $self->applyfont($t, $self->{STYLE}{thesisfont});
  } elsif ($type eq 'report') {
    $t = $self->applyfont($t, $self->{STYLE}{reportfont});
  } else {
    $t = $self->applyfont($t, $self->{STYLE}{titlefont});
  }

  $self->outputtext($t);
}

sub f_journal {
  my $self = shift;
  my $i = shift;

  my $t = $self->getfield('journal', 1);

  $t = $self->emph($t);

  $self->outputtext($t);
}

sub f_volnumpages {
  my $self = shift;
  my $i = shift;

  my $volume = $i->first_child('volume')->text;
  my $number = $i->first_child('number')->text;
  my $pages = $i->first_child('pages')->text;

  my $t = '';
  $t .= $volume if $volume;

  if ($number) {
    $t .= "($number)";
    $volume or $self->warning("There's a <number> but no <volume>");
  }

  if ($pages) {
    if ($t) {
      $t .= ":$pages";
    } else {
      $t = $pages;
    }
  }
  $self->outputtext($t);
}

sub f_year {
  my $self = shift;
  my $i = shift;

  my $type = $self->{CUREL}->tag;

  if ($type eq 'article' or $type eq 'thesis') {
    # output full date
    my $y = $self->getfield('year', 1);
    my $attr = $i->atts;
    my ($m, $d) = ($attr->{month}, $attr->{day});
    if (defined($m)) {
      $self->outputtext($self->monthyear($m, $y));
    } else {
      $self->outputtext($self->year($y));
    }
  } else {
    # output year only
    my $y = $self->getfield('year', 1);
    $self->outputtext($self->year($y));
  }
}

sub f_issn {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_howpublished {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_volume {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_volseries {
  my $self = shift;
  my $i = shift;
  my $volume = $i->first_child('volume')->text;
  my $series = $i->first_child('series')->text;

  $self->outputtext($self->volume($volume, $series));

}

sub f_number {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_crossref {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_thesisword {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_pages {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_key {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_place {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_edition {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_series {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_publisher {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_institution {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_chapter{
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_note {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->outputtext($t);
}

sub f_url {
  my $self = shift;
  my $i = shift;
  my $t = $i->text;
  $self->url($t);
}


###########################################################


sub returneditors {
  my $self = shift;

  my $i = $self->{CUREL}->first_child('editor');
  unless (defined($i)) {
    $self->warning("No <editor>");
    return;
  }

  return $self->formatnames($i) . ' (editor)';
}

sub formateditors {
  my $self = shift;

  $self->outputtext($self->returneditors);
}

sub formatnames {
  my $self = shift;
  my $authed = shift;

  my @r;
  my @d = $authed->descendants('name');
  foreach my $i (0 .. $#d) {
    push @r, $self->formatname($d[$i], $i);
  }

  return $self->andlist(@r);
}

sub formatname {
  my $self = shift;

  my $name = shift;
  my $pos = shift;

  my ($given, $von, $family, $extrafamily, $jr)
    = (perhapstext($name->first_child('given')),
       perhapstext($name->first_child('von')),
       perhapstext($name->first_child('family')),
       perhapstext($name->first_child('extrafamily')),
       perhapstext($name->first_child('jr')));

  my $r = $family;

  defined($extrafamily) and $r .= ' ' . $extrafamily;

  if (defined($von)) {
    if ($self->{STYLE}{von} eq 'partoffamily') {
      $r = "$von $r";
    } else {
      $r = "$r von";
    }
  }

  if (defined($given)) {
    if ($self->{STYLE}{nameorder} eq 'givenfirst') {
      $r = "$given $r";
    } elsif ($self->{STYLE}{nameorder} eq 'familyfirst') {
      $r .= ", $given";
    }
  }

  defined($jr) and $r .= ", $von";

  return $r;
}

# if the text field is defined, then return it else undef
sub perhapstext {
  my $e = shift;
  if (defined($e)) {
    return $e->text;
  } else {
    return undef;
  }
}

sub formatinstitution {
  my $self = shift;

  my $inst = $self->getfield('institution');

  $self->outputtext($inst);
}

sub formatpublisher {
  my $self = shift;

  my $publ = $self->getfield('publisher');

  $self->outputtext($publ);
}

sub formatnumberseries {
  my $self = shift;

  $self->getfield('volume') and return; # Skip if there's a volume

  my $number = $self->getfield('number');
  my $series = $self->getfield('series');

  my $t = '';

  if (!$number) {
    $t = $series;
  } else {
    $self->warning("There's a <number> but no <series>") unless $series;
    $t .= $self->numberseries($number, $series);
  }

  $self->outputtext($t);
}

sub formatvolume {
  my $self = shift;

  my $t = $self->getfield('volume', 1);

  $t and $t = "volume $t";

  $self->outputtext($t);
}

sub formatinedbooktitle {
  my $self = shift;

  my $t = '';
  my $title = $self->getfield('booktitle');
  my $editor = $self->getfield('editor');

  if ($title) {
    $t = 'In ';
    if ($editor) {
      $t .= $self->returneditors . $self->comma;
    }
    $t .= $self->emph($title);
  }

  $self->outputtext($t);
}

sub formatbvolume {
  my $self = shift;

  my $t = '';
  my $volume = $self->getfield('volume');
  my $series = $self->getfield('series');
  my $number = $self->getfield('number'); # only needed for validation!

  if ($volume) {
    $t = $self->volume($volume, $series && $self->emph($series));
    if ($number) {
      $self->warning("Can't use both <volume> and <number> fields");
    }
  }

  $self->outputtext($t);
}

sub formatthesistype {
  my $self = shift;

  my $type = $self->getatt('type');

  $self->outputtext($self->thesis($type));
}

sub formathowpublished {
  my $self = shift;

  my $t = $self->getfield('howpublished');

  $self->outputtext($t);
}

sub formatedition {
  my $self = shift;


  my $t = $self->getfield('edition');

  $t and $t = $self->edition($t);

  $self->outputtext($t);
}

sub formatpublisheraddress {
  my $self = shift;

  my $t = $self->getfield('publisher');
  $self->outputtext($t);

  $t = $self->getfield('place');
  $self->outputtext($t);
}

sub formataddress {
  my $self = shift;

  my $t = $self->getfield('place');
  $self->outputtext($t);
}

sub formatcrossref {
  my $self = shift;

  my $i = $self->{CUREL}->first_child('crossref');
  unless (defined($i)) {
    $self->warning("No <crossref>");
    return;
  }

  my $t = $i->atts->{id};

  $self->outputtext($self->in($self->outputcite($t)));
}

sub formatchapterpages {
  my $self = shift;

  my $pages = $self->getfield('pages');
  my $chapter = $self->getfield('chapter');

  if (!$chapter) {
    $self->formatpages;
  } else {
    # TYPE has been eliminated -- might come in again as attribute
    my $t = $self->chapter($chapter);
    $pages and $t .= ", $pages";
    $self->outputtext($t);
  }
}

sub formattrnumber {
  my $self = shift;

  my $number = $self->getfield('number');

  # TYPE has been eliminated -- might come in again as attribute
  my $t = $self->technicalreport($number);
  $self->outputtext($t);
}

sub formatpages {
  my $self = shift;

  my $t = $self->getfield('pages', 1);

  $self->outputtext($t);
}

sub formatrest {
  my $self = shift;

  # handle notes, annotations, ISBN & ISSN numbers etc. here

  my $i = $self->{CUREL}->first_child('note');
  if (defined($i)) {
    my $t = $i->text;
    $self->outputtext($t);
  }
}

sub applyfont {
  my $self = shift;
  my $text = shift;
  my $font = shift;

  return $self->$font($text);
}

1;
