package Bibulus::HTML;

# For copyright and license please see the final part of this file.

use strict;
use warnings;
use Carp;
use Bibulus;

our @ISA = qw(Bibulus);

# Debugging is a package global:
my $DEBUG = 0;
sub setdebug {
  $DEBUG = 1;
  print STDERR 'This is Bibulus::HTML $Id: HTML.pm,v 1.5 2004/05/05 21:52:15 twid Exp $', "\n";
  Bibulus->setdebug;
}

# Override Bibulus built-ins to output HTML

sub bibliography_start {
  my $self = shift;
  return "<html>\n<h1>Bibliography</h1>\n";
}

sub bibliography_end {
  my $self = shift;
  return "</html>\n";
}

sub item_start {
  my $self = shift;
  my ($id, $label) = @_;
  my $t;
  $t = '';
  defined($label) and $t = "[$label]\n";
  return $t;
}

sub item_end {
  my $self = shift;
  return "<br>\n";
}

sub newblock {
  my $self = shift;
  return "\n";
}

sub emph {
  my $self = shift;
  my ($t) = @_;
  return "<em>$t</em>";
}

sub bold {
  my ($t) = @_;
  return "<b>$t</b>";
}

1;
__END__

=head1 NAME

Bibulus::HTML - Perl extension for making Bibulus output in HTML

=head1 SYNOPSIS

  use Bibulus::HTML;
  my $bib = new Bibulus::HTML;
  $bib->load('testbib');
  $bib->cite('somebook');
  print $bib->getbib;

=head1 DESCRIPTION

Slightly alters Bibulus output routines so that they genereate
HTML instead of plain text.

=head2 EXPORT

None.

=head1 SEE ALSO

Check the main Bibulus module.

The homepage at present is
E<lt>http://www.nongnu.org/bibulus/E<gt>.

=head1 AUTHOR

Thomas M. Widmann, E<lt>twid@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
