package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# Create sort-keys
sub gensortkeys {
  my $self = shift;
  my $i;
  foreach $i (@{$self->{EL}}) {
    my $e = new XML::Twig::Elt('sortkey', sortkey_author($i) .
			      sortkey_year($i));
    $e->paste('last_child', $i);
  }
}

sub sortkey_author {
  my ($i) = @_;
  my $t = $i->first_child('author') or return '';
  my $s = $t->first_child('name') or return '';
  my $sortkey = $s->first_child('family')->text or return '';

  return $sortkey;
}

sub sortkey_year {
  my ($i) = @_;
  my $t = $i->first_child('year');
  defined($t) or return 0;
  my $sortkey = $t->text;

  return $sortkey;
}

# sort
sub sortbib {
  my $self = shift;
  # cmp is really too simplistic, but it'll do for the moment
  @{$self->{EL}} = sort {$a->first_child('sortkey')->text
			   cmp $b->first_child('sortkey')->text}
    @{$self->{EL}};
}

1;
