package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# This files contains various functions to deal with languages.

sub setmainlang {
  my $self = shift;
  my $lang = shift;
  $self->lang($lang);
  $self->{MAINLANG} = $lang;
}

# A function to get and set languages.  Originally, it verified the
# language, but that will make it difficult for users to add more
# languages.  Perhaps one should strip off _XX (country codes)?
sub lang {
  my $self = shift;

  if (@_) {
    my $l = shift;

    # Some language codes are aliases or indicate a group of
    # languages. Such codes should be translated to something
    # more usable.
    $l = 'nb' if $l eq 'no';

    $self->{LANG} = $l;
  }

  return $self->{LANG};
}

# This is magic: Whenever a function in Bibulus::Lang is called
# that doesn't exist, this function will search for it in the
# relevant language module.
# E.g., if Bibulus::mastersthesis is called and
# $self->{LANG} eq 'da', then Bibulus:da:mastersthesis
# will be called instead (and that will presumably return 'speciale').
sub AUTOLOAD {
  my ($self) = @_;
  my ($pkg, $meth) = $AUTOLOAD =~ /(.*)::(.*)/;
  $meth =~ /DESTROY/ and return;
  my $m;

  # Get into the right namespace:
  eval "require Bibulus::$self->{LANG}" or die $@;

  # Load some text strings into $self if they're not there already:
  $meth ne 'populate' and !defined($self->{LANGINIT}{$self->{LANG}})
    and $self->populate;
  $m = "Bibulus::$self->{LANG}::$meth";

  # Now go to the function if it's there
  defined(&$m) and goto &$m;

  # If it's not, look for it in general.pm:
  eval "require Bibulus::general" or die $@;
  $m = "Bibulus::general::$meth";
  defined(&$m) and goto &$m;

  # Otherwise, die!
  die "$m not found in $self->{LANG} or general.\n";
}

1;
