package Bibulus::es;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{es}{and} ||= 'y';
  $self->{LANGTEXT}{es}{etal} ||= 'et al.';
  $self->{LANGTEXT}{es}{editors}{full} ||= 'editores';
  $self->{LANGTEXT}{es}{editors}{abbr} ||= 'eds.';
  $self->{LANGTEXT}{es}{editor}{full} ||= 'editor';
  $self->{LANGTEXT}{es}{editor}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{es}{edby} ||= 'editado por';
  $self->{LANGTEXT}{es}{edition}{full} ||= 'edición';
  $self->{LANGTEXT}{es}{edition}{abbr} ||= 'edón.';
  $self->{LANGTEXT}{es}{volume} ||= 'tomo';
  $self->{LANGTEXT}{es}{of} ||= 'de';
  $self->{LANGTEXT}{es}{number}{full} ||= 'número';
  $self->{LANGTEXT}{es}{number}{abbr} ||= 'nº';
  $self->{LANGTEXT}{es}{nr} ||= 'nº';
  $self->{LANGTEXT}{es}{in} ||= 'en';
  $self->{LANGTEXT}{es}{pages}{full} ||= 'páginas';
  $self->{LANGTEXT}{es}{pages}{abbr} ||= 'págs.';
  $self->{LANGTEXT}{es}{page}{full} ||= 'página';
  $self->{LANGTEXT}{es}{page}{abbr} ||= 'pág.';
  $self->{LANGTEXT}{es}{eidpp} ||= 'páginas';
  $self->{LANGTEXT}{es}{chapter}{full} ||= 'capítulo';
  $self->{LANGTEXT}{es}{chapter}{abbr} ||= 'cap.';
  $self->{LANGTEXT}{es}{techrep}{full} ||= 'Informe Técnico';
  $self->{LANGTEXT}{es}{techrep}{abbr} ||= 'Inf. Téc.';
  $self->{LANGTEXT}{es}{mthesis} ||= 'Proyecto Fin de Carrera';
  $self->{LANGTEXT}{es}{phdthesis} ||= 'Tesis Doctoral';
  $self->{LANGTEXT}{es}{edno}{1}{full} ||= 'primera';
  $self->{LANGTEXT}{es}{edno}{1}{abbr} ||= '1ª';
  $self->{LANGTEXT}{es}{edno}{2}{full} ||= 'segunda';
  $self->{LANGTEXT}{es}{edno}{2}{abbr} ||= '2ª';
  $self->{LANGTEXT}{es}{edno}{3}{full} ||= 'tercera';
  $self->{LANGTEXT}{es}{edno}{3}{abbr} ||= '3ª';
  $self->{LANGTEXT}{es}{edno}{4}{full} ||= 'cuarta';
  $self->{LANGTEXT}{es}{edno}{4}{abbr} ||= '4ª';
  $self->{LANGTEXT}{es}{edno}{5}{full} ||= 'quinta';
  $self->{LANGTEXT}{es}{edno}{5}{abbr} ||= '5ª';
  $self->{LANGTEXT}{es}{th} ||= 'ª';
  $self->{LANGTEXT}{es}{month}{1}{full} ||= 'enero';
  $self->{LANGTEXT}{es}{month}{2}{full} ||= 'febrero';
  $self->{LANGTEXT}{es}{month}{3}{full} ||= 'marzo';
  $self->{LANGTEXT}{es}{month}{4}{full} ||= 'abril';
  $self->{LANGTEXT}{es}{month}{5}{full} ||= 'mayo';
  $self->{LANGTEXT}{es}{month}{6}{full} ||= 'junio';
  $self->{LANGTEXT}{es}{month}{7}{full} ||= 'julio';
  $self->{LANGTEXT}{es}{month}{8}{full} ||= 'agosto';
  $self->{LANGTEXT}{es}{month}{9}{full} ||= 'septiembre';
  $self->{LANGTEXT}{es}{month}{10}{full} ||= 'octubre';
  $self->{LANGTEXT}{es}{month}{11}{full} ||= 'noviembre';
  $self->{LANGTEXT}{es}{month}{12}{full} ||= 'diciembre';
  $self->{LANGTEXT}{es}{month}{1}{abbr} ||= 'ene.';
  $self->{LANGTEXT}{es}{month}{2}{abbr} ||= 'feb.';
  $self->{LANGTEXT}{es}{month}{3}{abbr} ||= 'mar.';
  $self->{LANGTEXT}{es}{month}{4}{abbr} ||= 'abr.';
  $self->{LANGTEXT}{es}{month}{5}{abbr} ||= 'mayo';
  $self->{LANGTEXT}{es}{month}{6}{abbr} ||= 'jun.';
  $self->{LANGTEXT}{es}{month}{7}{abbr} ||= 'jul.';
  $self->{LANGTEXT}{es}{month}{8}{abbr} ||= 'ago.';
  $self->{LANGTEXT}{es}{month}{9}{abbr} ||= 'sep.';
  $self->{LANGTEXT}{es}{month}{10}{abbr} ||= 'oct.';
  $self->{LANGTEXT}{es}{month}{11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{es}{month}{12}{abbr} ||= 'dic.';

  $self->{LANGINIT}{es} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::es - Bibulus support for Spanish

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
