package Bibulus::ca;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{ca}{and} ||= 'i';
  $self->{LANGTEXT}{ca}{etal} ||= 'et al.';
  $self->{LANGTEXT}{ca}{editors}{full} ||= 'editors';
  $self->{LANGTEXT}{ca}{editors}{abbr} ||= 'eds.';
  $self->{LANGTEXT}{ca}{editor}{full} ||= 'editor';
  $self->{LANGTEXT}{ca}{editor}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{ca}{edby} ||= 'editat per';
  $self->{LANGTEXT}{ca}{edition}{full} ||= 'edició';
  $self->{LANGTEXT}{ca}{edition}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{ca}{volume}{full} ||= 'volum';
  $self->{LANGTEXT}{ca}{volume}{abbr} ||= 'vol.';
  $self->{LANGTEXT}{ca}{of} ||= 'de';
  $self->{LANGTEXT}{ca}{number}{full} ||= 'número';
  $self->{LANGTEXT}{ca}{number}{abbr} ||= 'núm.';
  $self->{LANGTEXT}{ca}{nr} ||= 'n.';
  $self->{LANGTEXT}{ca}{in} ||= 'dins';
  $self->{LANGTEXT}{ca}{pages}{full} ||= 'pàgines';
  $self->{LANGTEXT}{ca}{pages}{abbr} ||= 'ps.';
  $self->{LANGTEXT}{ca}{page}{full} ||= 'pàgina';
  $self->{LANGTEXT}{ca}{page}{abbr} ||= 'p.';
  $self->{LANGTEXT}{ca}{eidpp} ||= 'pàgines';
  $self->{LANGTEXT}{ca}{chapter}{full} ||= 'capítol';
  $self->{LANGTEXT}{ca}{chapter}{abbr} ||= 'cap.';
  $self->{LANGTEXT}{ca}{techrep}{full} ||= 'Report tècnic';
  $self->{LANGTEXT}{ca}{techrep}{abbr} ||= 'Rep. Tèc.';
  $self->{LANGTEXT}{ca}{mthesis} ||= 'Projecte F. de Carrera o Tesina de L.';
  $self->{LANGTEXT}{ca}{phdthesis} ||= 'Tesi Doctoral';
  $self->{LANGTEXT}{ca}{edno}{1}{abbr} ||= '1a';
  $self->{LANGTEXT}{ca}{edno}{1}{full} ||= 'primera';
  $self->{LANGTEXT}{ca}{edno}{2}{abbr} ||= '2a';
  $self->{LANGTEXT}{ca}{edno}{2}{full} ||= 'segona';
  $self->{LANGTEXT}{ca}{edno}{3}{abbr} ||= '3a';
  $self->{LANGTEXT}{ca}{edno}{3}{full} ||= 'tercera';
  $self->{LANGTEXT}{ca}{edno}{4}{abbr} ||= '4a';
  $self->{LANGTEXT}{ca}{edno}{4}{full} ||= 'quarta';
  $self->{LANGTEXT}{ca}{edno}{5}{abbr} ||= '5a';
  $self->{LANGTEXT}{ca}{edno}{5}{full} ||= 'cinquena';
  $self->{LANGTEXT}{ca}{th} ||= 'a';
  $self->{LANGTEXT}{ca}{month}{1}{full} ||= 'gener';
  $self->{LANGTEXT}{ca}{month}{2}{full} ||= 'febrer';
  $self->{LANGTEXT}{ca}{month}{3}{full} ||= 'març';
  $self->{LANGTEXT}{ca}{month}{4}{full} ||= 'abril';
  $self->{LANGTEXT}{ca}{month}{5}{full} ||= 'maig';
  $self->{LANGTEXT}{ca}{month}{6}{full} ||= 'juny';
  $self->{LANGTEXT}{ca}{month}{7}{full} ||= 'juliol';
  $self->{LANGTEXT}{ca}{month}{8}{full} ||= 'agost';
  $self->{LANGTEXT}{ca}{month}{9}{full} ||= 'setembre';
  $self->{LANGTEXT}{ca}{month}{10}{full} ||= 'octubre';
  $self->{LANGTEXT}{ca}{month}{11}{full} ||= 'novembre';
  $self->{LANGTEXT}{ca}{month}{12}{full} ||= 'desembre';
  $self->{LANGTEXT}{ca}{month}{1}{abbr} ||= 'gen.';
  $self->{LANGTEXT}{ca}{month}{2}{abbr} ||= 'feb.';
  $self->{LANGTEXT}{ca}{month}{3}{abbr} ||= 'març';
  $self->{LANGTEXT}{ca}{month}{4}{abbr} ||= 'abr.';
  $self->{LANGTEXT}{ca}{month}{5}{abbr} ||= 'maig';
  $self->{LANGTEXT}{ca}{month}{6}{abbr} ||= 'juny';
  $self->{LANGTEXT}{ca}{month}{7}{abbr} ||= 'jul.';
  $self->{LANGTEXT}{ca}{month}{8}{abbr} ||= 'ag.';
  $self->{LANGTEXT}{ca}{month}{9}{abbr} ||= 'set.';
  $self->{LANGTEXT}{ca}{month}{10}{abbr} ||= 'oct.';
  $self->{LANGTEXT}{ca}{month}{11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{ca}{month}{12}{abbr} ||= 'des.';

  $self->{LANGINIT}{ca} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::ca - Bibulus support for Catalan

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
