# This file is part of Bibulus.
# Copyright 2003 by Thomas Widmann
# under the GNU Public License version 2.

use 5.006;  # 5.008 is recommended
use ExtUtils::MakeMaker;

my $prefix;  # for use in constants and postamble

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'Bibulus',
    'VERSION'	        => '0.13',
    'EXE_FILES'         => [],
    'PREREQ_PM'		=> {XML::Twig => 3.09},
	      # we'll also need some ICU stuff for sorting

    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM => 'Bibulus.pm',
       AUTHOR     => 'Thomas M. Widmann <twid@cpan.org>') : ()),
);

package MY;

# we don't modify anything, but we have to find out what the
# installation prefix is -- is there any direct way?
sub constants {
  my $inherited = shift->SUPER::constants(@_);
  $inherited =~ /PREFIX = (.*)/ and $prefix = $1;
  return $inherited;
}

sub postamble {
  my $dir;
  if ($prefix =~ /^\/usr/) {
    # probably installing centrally
    chomp($dir = `kpsewhich --expand-var=\'\$TEXMFLOCAL\'`);
    unless (-e $dir) {
      chomp($dir = `kpsewhich --expand-var=\'\$TEXMFMAIN\'`);
    }
  } else {
    # probably installing in user's home directory
    chomp($dir = `kpsewhich --expand-var=\'\$HOMETEXMF\'`);
  }

  return <<"EOF";
install::
	\@echo Now updating the TEXMF tree...
	install -d $dir/bibtex/bst/misc
	cp BibTeX/bib2xml.bst $dir/bibtex/bst/misc/
	install -d $dir/tex/latex/misc
	cp LaTeX/bibulus.sty $dir/tex/latex/misc/
	mktexlsr $dir

EOF
}
