package Bibulus::sl;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{sl}{and} ||= 'in';
  $self->{LANGTEXT}{sl}{etal} ||= 'in sod.';
  $self->{LANGTEXT}{sl}{editors}{full} ||= 'Uredniki';
  $self->{LANGTEXT}{sl}{editors}{abbr} ||= 'ur.';
  $self->{LANGTEXT}{sl}{editor}{full} ||= 'Urednik';
  $self->{LANGTEXT}{sl}{editor}{abbr} ||= 'ur.';
  $self->{LANGTEXT}{sl}{edby} ||= 'uredil';
  $self->{LANGTEXT}{sl}{edition}{full} ||= 'izdaja';
  $self->{LANGTEXT}{sl}{edition}{abbr} ||= 'izd.';
  $self->{LANGTEXT}{sl}{volume}{full} ||= 'zvezek';
  $self->{LANGTEXT}{sl}{volume}{abbr} ||= 'zv.';
  $self->{LANGTEXT}{sl}{of} ||= 'od';
  $self->{LANGTEXT}{sl}{number}{full} ||= 'številka';
  $self->{LANGTEXT}{sl}{number}{abbr} ||= 'št.';
  $self->{LANGTEXT}{sl}{nr} ||= 'št.';
  $self->{LANGTEXT}{sl}{in} ||= 'v';
  $self->{LANGTEXT}{sl}{pages}{full} ||= 'strani';
  $self->{LANGTEXT}{sl}{pages}{abbr} ||= 'str.';
  $self->{LANGTEXT}{sl}{page}{full} ||= 'stran';
  $self->{LANGTEXT}{sl}{page}{abbr} ||= 'str.';
  $self->{LANGTEXT}{sl}{chapter}{full} ||= 'poglavje';
  $self->{LANGTEXT}{sl}{chapter}{abbr} ||= 'pogl.';
  $self->{LANGTEXT}{sl}{techrep}{full} ||= 'Tehnično poročilo';
  $self->{LANGTEXT}{sl}{techrep}{abbr} ||= 'Tehn. por.';
  $self->{LANGTEXT}{sl}{mthesis} ||= 'Magistrsko delo';
  $self->{LANGTEXT}{sl}{phdthesis} ||= 'Doktorsko delo';
  $self->{LANGTEXT}{sl}{edno}{1}{full} ||= 'prva';
  $self->{LANGTEXT}{sl}{edno}{1}{abbr} ||= '1.';
  $self->{LANGTEXT}{sl}{edno}{2}{full} ||= 'druga';
  $self->{LANGTEXT}{sl}{edno}{2}{abbr} ||= '2.';
  $self->{LANGTEXT}{sl}{edno}{3}{full} ||= 'tretja';
  $self->{LANGTEXT}{sl}{edno}{3}{abbr} ||= '3.';
  $self->{LANGTEXT}{sl}{edno}{4}{full} ||= 'četrta';
  $self->{LANGTEXT}{sl}{edno}{4}{abbr} ||= '4.';
  $self->{LANGTEXT}{sl}{edno}{5}{full} ||= 'peta';
  $self->{LANGTEXT}{sl}{edno}{5}{abbr} ||= '5.';
  $self->{LANGTEXT}{sl}{th} ||= '.';
  $self->{LANGTEXT}{sl}{month}{1}{full} ||= 'januar';
  $self->{LANGTEXT}{sl}{month}{2}{full} ||= 'februar';
  $self->{LANGTEXT}{sl}{month}{3}{full} ||= 'marec';
  $self->{LANGTEXT}{sl}{month}{4}{full} ||= 'april';
  $self->{LANGTEXT}{sl}{month}{5}{full} ||= 'maj';
  $self->{LANGTEXT}{sl}{month}{6}{full} ||= 'junij';
  $self->{LANGTEXT}{sl}{month}{7}{full} ||= 'julij';
  $self->{LANGTEXT}{sl}{month}{8}{full} ||= 'avgust';
  $self->{LANGTEXT}{sl}{month}{9}{full} ||= 'september';
  $self->{LANGTEXT}{sl}{month}{10}{full} ||= 'oktober';
  $self->{LANGTEXT}{sl}{month}{11}{full} ||= 'november';
  $self->{LANGTEXT}{sl}{month}{12}{full} ||= 'december';
  $self->{LANGTEXT}{sl}{month}{1}{abbr} ||= 'jan.';
  $self->{LANGTEXT}{sl}{month}{2}{abbr} ||= 'feb.';
  $self->{LANGTEXT}{sl}{month}{3}{abbr} ||= 'mar.';
  $self->{LANGTEXT}{sl}{month}{4}{abbr} ||= 'apr.';
  $self->{LANGTEXT}{sl}{month}{5}{abbr} ||= 'maj';
  $self->{LANGTEXT}{sl}{month}{6}{abbr} ||= 'jun.';
  $self->{LANGTEXT}{sl}{month}{7}{abbr} ||= 'jul.';
  $self->{LANGTEXT}{sl}{month}{8}{abbr} ||= 'avg.';
  $self->{LANGTEXT}{sl}{month}{9}{abbr} ||= 'sep.';
  $self->{LANGTEXT}{sl}{month}{10}{abbr} ||= 'okt.';
  $self->{LANGTEXT}{sl}{month}{11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{sl}{month}{12}{abbr} ||= 'dec.';

  $self->{LANGINIT}{sl} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::sl - Bibulus support for Slovenian

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
