package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# Output primitives.  They should normally be redefined.

sub bibliography_start { return ''; }

sub bibliography_end { return ''; }

sub item_start {
  my $self = shift;
  my ($id, $label) = @_;
  defined($label) and return brackets($label) or return brackets($id);
}

sub item_end { return ''; }

sub newblock { return ''; }

sub brackets {
  my $self = shift;
  my ($t) = @_;

  defined($t) or return '';

  return '[' . $t . ']';
}

sub emph {
  my $self = shift;
  my ($t) = @_;
  return '_' . $t . '_';
}

sub bold {
  my ($t) = @_;
  return '*' . $t . '*';
}

sub smallcaps {
  my ($t) = @_;
  return uc($t);
}

sub fullcaps {
  my ($t) = @_;
  return uc($t);
}

sub singlequote {
  my ($t) = @_;
  return "'$t'";
}

sub doublequote {
  my ($t) = @_;
  return "\"$t\"";
}

sub outputcite {
  my $self = shift;
  my $c = shift;
  return "\\cite{$c}";
}

sub nobreakspace {
  return ' ';
}

sub language {
  my $self = shift;
  my ($lang, $t) = @_;

  return $t;
}

1;
