package Bibulus::nn;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{nb}{etal} ||= 'm.fl.';
  $self->{LANGTEXT}{nb}{editors}{full} ||= 'redaktører';
  $self->{LANGTEXT}{nb}{editors}{abbr} ||= 'red.';
  $self->{LANGTEXT}{nb}{editor}{full} ||= 'redaktør';
  $self->{LANGTEXT}{nb}{editor}{abbr} ||= 'red.';
  $self->{LANGTEXT}{nb}{edby} ||= 'redigert av';
  $self->{LANGTEXT}{nb}{edition}{full} ||= 'utgåve';
  $self->{LANGTEXT}{nb}{edition}{abbr} ||= 'utg.';
  $self->{LANGTEXT}{nb}{volume}{full} ||= 'band';
  $self->{LANGTEXT}{nb}{volume}{abbr} ||= 'bd.';
  $self->{LANGTEXT}{nb}{of} ||= 'av';
  $self->{LANGTEXT}{nb}{number}{full} ||= 'nummer';
  $self->{LANGTEXT}{nb}{number}{abbr} ||= 'nr.';
  $self->{LANGTEXT}{nb}{nr} ||= 'nr.';
  $self->{LANGTEXT}{nb}{in} ||= 'i';
  $self->{LANGTEXT}{nb}{pages}{full} ||= 'sider';
  $self->{LANGTEXT}{nb}{pages}{abbr} ||= 'ss.';
  $self->{LANGTEXT}{nb}{page}{full} ||= 'side';
  $self->{LANGTEXT}{nb}{page}{abbr} ||= 's.';
  $self->{LANGTEXT}{nb}{eidpp} ||= 'sider';
  $self->{LANGTEXT}{nb}{chapter}{full} ||= 'kapittel';
  $self->{LANGTEXT}{nb}{chapter}{abbr} ||= 'kap.';
  $self->{LANGTEXT}{nb}{techrep}{full} ||= 'Teknisk rapport';
  $self->{LANGTEXT}{nb}{techrep}{abbr} ||= 'Tekn. rap.';
  $self->{LANGTEXT}{nb}{mthesis} ||= 'Hovudoppgåve';
  $self->{LANGTEXT}{nb}{phdthesis} ||= 'Doktorgradsavhandling';
  $self->{LANGTEXT}{nb}{edno}{1}{full} ||= 'Første';
  $self->{LANGTEXT}{nb}{edno}{1}{abbr} ||= '1.';
  $self->{LANGTEXT}{nb}{edno}{2}{full} ||= 'Andre';
  $self->{LANGTEXT}{nb}{edno}{2}{abbr} ||= '2.';
  $self->{LANGTEXT}{nb}{edno}{3}{full} ||= 'Tredje';
  $self->{LANGTEXT}{nb}{edno}{3}{abbr} ||= '3.';
  $self->{LANGTEXT}{nb}{edno}{4}{full} ||= 'Fjerde';
  $self->{LANGTEXT}{nb}{edno}{4}{abbr} ||= '4.';
  $self->{LANGTEXT}{nb}{edno}{5}{full} ||= 'Femte';
  $self->{LANGTEXT}{nb}{edno}{5}{abbr} ||= '5.';
  $self->{LANGTEXT}{nb}{th} ||= '.';
  $self->{LANGTEXT}{nb}{month}{1}{full} ||= 'Januar';
  $self->{LANGTEXT}{nb}{month}{2}{full} ||= 'Februar';
  $self->{LANGTEXT}{nb}{month}{3}{full} ||= 'Mars';
  $self->{LANGTEXT}{nb}{month}{4}{full} ||= 'April';
  $self->{LANGTEXT}{nb}{month}{5}{full} ||= 'Mai';
  $self->{LANGTEXT}{nb}{month}{6}{full} ||= 'Juni';
  $self->{LANGTEXT}{nb}{month}{7}{full} ||= 'Juli';
  $self->{LANGTEXT}{nb}{month}{8}{full} ||= 'August';
  $self->{LANGTEXT}{nb}{month}{9}{full} ||= 'September';
  $self->{LANGTEXT}{nb}{month}{10}{full} ||= 'Oktober';
  $self->{LANGTEXT}{nb}{month}{11}{full} ||= 'November';
  $self->{LANGTEXT}{nb}{month}{12}{full} ||= 'Desember';
  $self->{LANGTEXT}{nb}{month}{1}{abbr} ||= 'Jan.';
  $self->{LANGTEXT}{nb}{month}{2}{abbr} ||= 'Feb.';
  $self->{LANGTEXT}{nb}{month}{3}{abbr} ||= 'Mar.';
  $self->{LANGTEXT}{nb}{month}{4}{abbr} ||= 'Apr.';
  $self->{LANGTEXT}{nb}{month}{5}{abbr} ||= 'Mai';
  $self->{LANGTEXT}{nb}{month}{6}{abbr} ||= 'Jun.';
  $self->{LANGTEXT}{nb}{month}{7}{abbr} ||= 'Jul.';
  $self->{LANGTEXT}{nb}{month}{8}{abbr} ||= 'Aug.';
  $self->{LANGTEXT}{nb}{month}{9}{abbr} ||= 'Sep.';
  $self->{LANGTEXT}{nb}{month}{10}{abbr} ||= 'Oct.';
  $self->{LANGTEXT}{nb}{month}{11}{abbr} ||= 'Nov.';
  $self->{LANGTEXT}{nb}{month}{12}{abbr} ||= 'Des.';

  $self->{LANGINIT}{nb} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::nb - Bibulus support for Norwegian (Nynorsk)

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>, F<Bibulus::nb>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHORS

Thomas M. Widmann, L<twid@cpan.org>
Marius L. Jøhndal, L<mariuslj@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann, Marius L. Jøhndal

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
