package Bibulus::nl;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{nl}{and} ||= 'en';
  $self->{LANGTEXT}{nl}{etal} ||= 'e.a.';
  $self->{LANGTEXT}{nl}{editors}{full} ||= 'redactie';
  $self->{LANGTEXT}{nl}{editors}{abbr} ||= 'red.';
  $self->{LANGTEXT}{nl}{editor}{full} ||= 'redactie';
  $self->{LANGTEXT}{nl}{editor}{abbr} ||= 'red.';
  $self->{LANGTEXT}{nl}{edby} ||= 'uitgegeven door';
  $self->{LANGTEXT}{nl}{edition}{full} ||= 'uitgave';
  $self->{LANGTEXT}{nl}{edition}{abbr} ||= 'druk';
  $self->{LANGTEXT}{nl}{volume}{full} ||= 'volume';
  $self->{LANGTEXT}{nl}{volume}{abbr} ||= 'vol.';
  $self->{LANGTEXT}{nl}{of} ||= 'van';
  $self->{LANGTEXT}{nl}{number}{full} ||= 'nummer';
  $self->{LANGTEXT}{nl}{number}{abbr} ||= 'nr.';
  $self->{LANGTEXT}{nl}{nr} ||= 'nr.';
  $self->{LANGTEXT}{nl}{in} ||= 'in';
  $self->{LANGTEXT}{nl}{pages}{full} ||= 'pagina's';
  $self->{LANGTEXT}{nl}{pages}{abbr} ||= 'pag.';
  $self->{LANGTEXT}{nl}{page}{full} ||= 'pagina';
  $self->{LANGTEXT}{nl}{page}{abbr} ||= 'pag.';
  $self->{LANGTEXT}{nl}{eidpp} ||= 'pagina's';
  $self->{LANGTEXT}{nl}{chapter}{full} ||= 'hoofdstuk';
  $self->{LANGTEXT}{nl}{chapter}{abbr} ||= 'hfdst.';
  $self->{LANGTEXT}{nl}{techrep}{full} ||= 'Technisch Rapport';
  $self->{LANGTEXT}{nl}{techrep}{abbr} ||= 'Tech. Rapp.';
  $self->{LANGTEXT}{nl}{mthesis} ||= 'scriptie';
  $self->{LANGTEXT}{nl}{phdthesis} ||= 'proefschrift';
  $self->{LANGTEXT}{nl}{edno}{1}{full} ||= 'eerste';
  $self->{LANGTEXT}{nl}{edno}{1}{abbr} ||= '1e';
  $self->{LANGTEXT}{nl}{edno}{2}{full} ||= 'tweede';
  $self->{LANGTEXT}{nl}{edno}{2}{abbr} ||= '2e';
  $self->{LANGTEXT}{nl}{edno}{3}{full} ||= 'derde';
  $self->{LANGTEXT}{nl}{edno}{3}{abbr} ||= '3e';
  $self->{LANGTEXT}{nl}{edno}{4}{full} ||= 'vierde';
  $self->{LANGTEXT}{nl}{edno}{4}{abbr} ||= '4e';
  $self->{LANGTEXT}{nl}{edno}{5}{full} ||= 'vijfde';
  $self->{LANGTEXT}{nl}{edno}{5}{abbr} ||= '5e';
  $self->{LANGTEXT}{nl}{st} ||= 'e';
  $self->{LANGTEXT}{nl}{nd} ||= 'e';
  $self->{LANGTEXT}{nl}{rd} ||= 'e';
  $self->{LANGTEXT}{nl}{th} ||= 'e';
  $self->{LANGTEXT}{nl}{month}{1}{full} ||= 'Januari';
  $self->{LANGTEXT}{nl}{month}{2}{full} ||= 'Februari';
  $self->{LANGTEXT}{nl}{month}{3}{full} ||= 'Maart';
  $self->{LANGTEXT}{nl}{month}{4}{full} ||= 'April';
  $self->{LANGTEXT}{nl}{month}{5}{full} ||= 'Mei';
  $self->{LANGTEXT}{nl}{month}{6}{full} ||= 'Juni';
  $self->{LANGTEXT}{nl}{month}{7}{full} ||= 'Juli';
  $self->{LANGTEXT}{nl}{month}{8}{full} ||= 'Augustus';
  $self->{LANGTEXT}{nl}{month}{9}{full} ||= 'September';
  $self->{LANGTEXT}{nl}{month}{10}{full} ||= 'Oktober';
  $self->{LANGTEXT}{nl}{month}{11}{full} ||= 'November';
  $self->{LANGTEXT}{nl}{month}{12}{full} ||= 'December';
  $self->{LANGTEXT}{nl}{month}{1}{abbr} ||= 'Jan.';
  $self->{LANGTEXT}{nl}{month}{2}{abbr} ||= 'Feb.';
  $self->{LANGTEXT}{nl}{month}{3}{abbr} ||= 'Mrt';
  $self->{LANGTEXT}{nl}{month}{4}{abbr} ||= 'Apr.';
  $self->{LANGTEXT}{nl}{month}{5}{abbr} ||= 'Mei';
  $self->{LANGTEXT}{nl}{month}{6}{abbr} ||= 'Jun.';
  $self->{LANGTEXT}{nl}{month}{7}{abbr} ||= 'Jul.';
  $self->{LANGTEXT}{nl}{month}{8}{abbr} ||= 'Aug.';
  $self->{LANGTEXT}{nl}{month}{9}{abbr} ||= 'Sep.';
  $self->{LANGTEXT}{nl}{month}{10}{abbr} ||= 'Okt.';
  $self->{LANGTEXT}{nl}{month}{11}{abbr} ||= 'Nov.';
  $self->{LANGTEXT}{nl}{month}{12}{abbr} ||= 'Dec.';

  $self->{LANGINIT}{nl} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::nl - Bibulus support for Dutch

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
