package Bibulus::fr;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{fr}{and} ||= 'et';
  $self->{LANGTEXT}{fr}{etal} ||= 'et al.';
  $self->{LANGTEXT}{fr}{editors}{full} ||= 'rédacteurs en chefs';
  $self->{LANGTEXT}{fr}{editors}{abbr} ||= 'réds.';
  $self->{LANGTEXT}{fr}{editor}{full} ||= 'rédacteur en chef';
  $self->{LANGTEXT}{fr}{editor}{abbr} ||= 'réd.';
  $self->{LANGTEXT}{fr}{edby} ||= 'dirigé par';
  $self->{LANGTEXT}{fr}{edition}{full} ||= 'édition';
  $self->{LANGTEXT}{fr}{edition}{abbr} ||= 'éd.';
  $self->{LANGTEXT}{fr}{volume}{full} ||= 'tome';
  $self->{LANGTEXT}{fr}{volume}{abbr} ||= 't.';
  $self->{LANGTEXT}{fr}{of} ||= 'de';
  $self->{LANGTEXT}{fr}{number}{full} ||= 'numéro';
  $self->{LANGTEXT}{fr}{number}{abbr} ||= 'nº';
  $self->{LANGTEXT}{fr}{nr} ||= 'nº';
  $self->{LANGTEXT}{fr}{in} ||= 'dans';
  $self->{LANGTEXT}{fr}{pages}{full} ||= 'pages';
  $self->{LANGTEXT}{fr}{pages}{abbr} ||= 'p.';
  $self->{LANGTEXT}{fr}{page}{full} ||= 'page';
  $self->{LANGTEXT}{fr}{page}{abbr} ||= 'p.';
  $self->{LANGTEXT}{fr}{eidpp} ||= 'pages';
  $self->{LANGTEXT}{fr}{chapter}{full} ||= 'chapitre';
  $self->{LANGTEXT}{fr}{chapter}{abbr} ||= 'chap.';
  $self->{LANGTEXT}{fr}{techrep}{full} ||= 'Rapport technique';
  $self->{LANGTEXT}{fr}{techrep}{abbr} ||= 'Rap. tech.';
  $self->{LANGTEXT}{fr}{mthesis} ||= 'Mémoire de maîtrise';
  $self->{LANGTEXT}{fr}{phdthesis} ||= 'Thèse de doctorat';
  $self->{LANGTEXT}{fr}{edno}{1}{full} ||= 'Première';
  $self->{LANGTEXT}{fr}{edno}{1}{abbr} ||= '1re';
  $self->{LANGTEXT}{fr}{edno}{2}{full} ||= 'Deuxième';
  $self->{LANGTEXT}{fr}{edno}{2}{abbr} ||= '2e';
  $self->{LANGTEXT}{fr}{edno}{3}{full} ||= 'Troisième';
  $self->{LANGTEXT}{fr}{edno}{3}{abbr} ||= '3e';
  $self->{LANGTEXT}{fr}{edno}{4}{full} ||= 'Quatrième';
  $self->{LANGTEXT}{fr}{edno}{4}{abbr} ||= '4e';
  $self->{LANGTEXT}{fr}{edno}{5}{full} ||= 'Cinquième';
  $self->{LANGTEXT}{fr}{edno}{5}{abbr} ||= '5e';
  $self->{LANGTEXT}{fr}{th} ||= 'e';
  $self->{LANGTEXT}{fr}{month}{1}{full} ||= 'janvier';
  $self->{LANGTEXT}{fr}{month}{2}{full} ||= 'février';
  $self->{LANGTEXT}{fr}{month}{3}{full} ||= 'mars';
  $self->{LANGTEXT}{fr}{month}{4}{full} ||= 'avril';
  $self->{LANGTEXT}{fr}{month}{5}{full} ||= 'mai';
  $self->{LANGTEXT}{fr}{month}{6}{full} ||= 'juin';
  $self->{LANGTEXT}{fr}{month}{7}{full} ||= 'juillet';
  $self->{LANGTEXT}{fr}{month}{8}{full} ||= 'août';
  $self->{LANGTEXT}{fr}{month}{9}{full} ||= 'septembre';
  $self->{LANGTEXT}{fr}{month}{10}{full} ||= 'octobre';
  $self->{LANGTEXT}{fr}{month}{11}{full} ||= 'novembre';
  $self->{LANGTEXT}{fr}{month}{12}{full} ||= 'décembre';
  $self->{LANGTEXT}{fr}{month}{1}{abbr} ||= 'jan.';
  $self->{LANGTEXT}{fr}{month}{2}{abbr} ||= 'fév.';
  $self->{LANGTEXT}{fr}{month}{3}{abbr} ||= 'mars';
  $self->{LANGTEXT}{fr}{month}{4}{abbr} ||= 'avr.';
  $self->{LANGTEXT}{fr}{month}{5}{abbr} ||= 'mai';
  $self->{LANGTEXT}{fr}{month}{6}{abbr} ||= 'juin';
  $self->{LANGTEXT}{fr}{month}{7}{abbr} ||= 'juil.';
  $self->{LANGTEXT}{fr}{month}{8}{abbr} ||= 'août';
  $self->{LANGTEXT}{fr}{month}{9}{abbr} ||= 'sept.';
  $self->{LANGTEXT}{fr}{month}{10}{abbr} ||= 'oct.';
  $self->{LANGTEXT}{fr}{month}{11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{fr}{month}{12}{abbr} ||= 'déc.';

  $self->{LANGINIT}{fr} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::fr - Bibulus support for French

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>
and Jean-Michel Hufflen

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
