/**
 * jline - Java console input library
 * Copyright (c) 2002,2003 Marc Prud'hommeaux marc@apocalypse.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package jline.example;

import jline.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

public class Example
{
	public static void usage ()
	{
		System.out.println ("Usage: java " + Example.class.getName ()
			+ " [none/simple/files/dictionary]");
		System.out.println ("  none - no completors");
		System.out.println ("  simple - a simple completor that comples "
			+ "\"foo\", \"bar\", and \"baz\"");
		System.out.println ("  files - a completor that comples "
			+ "file names");
		System.out.println ("  dictionary - a completor that comples "
			+ "english dictionary words");
	}


	public static void main (String [] args)
		throws IOException
	{
		Terminal t = Terminal.setupTerminal ();

		ConsoleReader reader = new ConsoleReader ();
		reader.setDebug (new PrintWriter (new FileWriter ("writer.debug",
			true)));

		if (args == null || args.length == 0)
		{
			usage ();
			return;
		}

		List completors = new LinkedList ();
		for (int i = 0; args != null && i < args.length; i++)
		{
			if (args [i].equals ("none"))
			{
			}
			else if (args [i].equals ("files"))
			{
				completors.add (new FileNameCompletor ());
			}
			else if (args [i].equals ("dictionary"))
			{
				completors.add (
					new SimpleCompletor (new GZIPInputStream (
						Example.class.getResourceAsStream ("english.gz"))));
			}
			else if (args [i].equals ("simple"))
			{
				completors.add (
 		 			new SimpleCompletor (
						new String [] { "foo", "bar", "baz"}));
			}
			else
			{
				usage ();
				return;
			}
		}

		reader.addCompletor (new ArgumentCompletor (completors));
					

		String line;
		PrintWriter out = new PrintWriter (System.out);
	
		while ((line = reader.readLine ("prompt> ")) != null)
		{
			out.println ("======>\"" + line + "\"");
			out.flush ();
		}
	}
}
