/**
 * jline - Java console input library
 * Copyright (c) 2002,2003 Marc Prud'hommeaux marc@apocalypse.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package jline;

import junit.framework.*;


/** 
 *  Tests command history.
 *  
 *  @author  <a href="mailto:marc@apocalypse.org">Marc Prud'hommeaux</a>
 */
public class TestHistory
	extends JLineTestCase
{
	public TestHistory (String test)
	{
		super (test);
	}


	public void testSingleHistory ()
		throws Exception
	{
		Buffer b = new Buffer ()
			.append ("test line 1").op (console.NEWLINE)
			.append ("test line 2").op (console.NEWLINE)
			.append ("test line 3").op (console.NEWLINE)
			.append ("test line 4").op (console.NEWLINE)
			.append ("test line 5").op (console.NEWLINE)
			.append ("");

		assertBuffer ("", b);

		assertBuffer ("test line 5", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 4", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 5", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("test line 4", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 3", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 2", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 1", b = b.op (console.PREV_HISTORY));

		// beginning of history
		assertBuffer ("test line 1", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 1", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 1", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 1", b = b.op (console.PREV_HISTORY));


		assertBuffer ("test line 2", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("test line 3", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("test line 4", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("test line 5", b = b.op (console.NEXT_HISTORY));


		// end of history
		assertBuffer ("", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("", b = b.op (console.NEXT_HISTORY));


		assertBuffer ("test line 5", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 4", b = b.op (console.PREV_HISTORY));
		b = b.op (console.MOVE_TO_BEG).append ("XXX").op (console.NEWLINE);
		assertBuffer ("XXXtest line 4", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 5", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 4", b = b.op (console.PREV_HISTORY));
		assertBuffer ("test line 5", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("XXXtest line 4", b = b.op (console.NEXT_HISTORY));
		assertBuffer ("", b = b.op (console.NEXT_HISTORY));


		assertBuffer ("XXXtest line 4", b = b.op (console.PREV_HISTORY));
		assertBuffer ("XXXtest line 4", b = b.op (console.NEWLINE)
			.op (console.PREV_HISTORY));
		assertBuffer ("XXXtest line 4", b = b.op (console.NEWLINE)
			.op (console.PREV_HISTORY));
		assertBuffer ("XXXtest line 4", b = b.op (console.NEWLINE)
			.op (console.PREV_HISTORY));
		assertBuffer ("XXXtest line 4", b = b.op (console.NEWLINE)
			.op (console.PREV_HISTORY));
	}
}

