/* -*- Mode: java; c-basic-indent: 4; tab-width: 4 -*- */
package freenet.transport;
//QUESTION: does this belong in this package?

import java.nio.channels.*;
import freenet.support.io.Bandwidth;

// For logging
import freenet.Core;
import freenet.support.Logger;

import java.net.Socket;
import java.util.*;
import java.io.IOException;

public abstract class ThrottledSelectorLoop extends AbstractSelectorLoop {

    /* The time at which to reregister everything on the throttleDisabledQueue
     */
    protected long reregisterThrottledTime = -1;
	
    /* The queue of ChannelAttachmentPairs disabled because of bandwidth
     * limiting.
     */
    protected final Vector throttleDisabledQueue;
    
	public final HashSet dontReregister = new HashSet();
	
//        protected Random rand;
	
	int throttleQueueLength = 0;
	
	public int throttleQueueLength() {
		return throttleQueueLength;
	}
	
    /*
     * Whether we are currently throttling - i.e. whether we have disabled
     * registrations and deregistered throttled connections temporarily to
     * backoff.
     */
    protected boolean throttling = false;
    
	public static final int OVERHEAD = 24;
	// Estimate based on hearsay about TCP and ethernet
	// FIXME: make this configurable
	
    protected Object throttleLock = new Object();
    // sync on this to prevent SelectorLoop thread from un-throttling
    
    protected Bandwidth bw;
    
    public ThrottledSelectorLoop(Bandwidth bw) throws IOException {
	
	this.bw = bw;
	throttleDisabledQueue = new Vector();
//        rand = freenet.Core.randSource;
    }
    
    public ThrottledSelectorLoop() throws IOException {
	
	this.bw = null;
	throttleDisabledQueue = new Vector();
//        rand = freenet.Core.randSource;
    }
    
	public void setBandwidth(Bandwidth bw) {
		this.bw = bw;
	}
	
    public final void throttleBeforeSelect() {
	boolean logDEBUG = Core.logger.shouldLog(Logger.DEBUG);
	if (throttling) {
	    long now = System.currentTimeMillis();
		if(logDEBUG)
			Core.logger.log(this, "Still throttling at "+now,
							Logger.DEBUG);
	    if(now >= reregisterThrottledTime) {
			synchronized(throttleLock) {
				Core.logger.log(this, "Reregistering throttled connections "+
								"at "+now, Logger.MINOR);
				throttling = false;
				reregisterThrottledTime = -1;
				int registered = 0;
				int closed = 0;
				while(!throttleDisabledQueue.isEmpty()) {
					throttleQueueLength = throttleDisabledQueue.size();
//                                        int x = rand.nextInt(throttleDisabledQueue.size());
					ChannelAttachmentPair current =
						(ChannelAttachmentPair)(throttleDisabledQueue.
												firstElement());
// 						(ChannelAttachmentPair)(throttleDisabledQueue.
// 												elementAt(x));
// 					throttleDisabledQueue.removeElementAt(x);
					throttleDisabledQueue.removeElementAt(0);
					// Hopefully the selector doesn't reorder them?
					try {
						if(!current.channel.isOpen()) {
							queueClose(current);
							closed++;
						} else {
							synchronized(dontReregister) {
								if(dontReregister.contains(current.channel)) {
									Core.logger.log(this, "Not reregistering "+current,
													Logger.DEBUG);
									dontReregister.remove(current.channel);
									continue;
								}
							}
							current.channel.register(sel, myKeyOps(), 
													 current.attachment);
							registered++;
							//Core.logger.log(this, "Reregistered "+current,
							//				Logger.DEBUG);
							// Already thinks it is registered
						}
					} catch (CancelledKeyException e) {
						Core.logger.log(this, "Key ("+current+
										") cancelled but not removed: "+e, e,
										Logger.ERROR);
						queueClose(current);
						closed++;
					} catch (ClosedChannelException e) {
						Core.logger.log(this, "Key ("+current+
										") channel closed but not removed: "+e,
										e, Logger.ERROR);
						queueClose(current);
						closed++;
						continue;
					}
				}
				throttleQueueLength = throttleDisabledQueue.size();
				now = System.currentTimeMillis();
				Core.logger.log(this, "Reregistered throttled connections: "+
								registered+" registered, "+closed+
								" closed, "+sel.keys().size()+" keys at "+now,
								Logger.MINOR);
				timeout = 0;
			}
	    } else {
			if(timeout > (reregisterThrottledTime - now)) {
				timeout = (int)(reregisterThrottledTime - now);
			}
			if(logDEBUG)
				Core.logger.log(this, "Set timeout to "+timeout,
								Logger.DEBUG);
	    }
	} else timeout = TIMEOUT;
    }
    
	int currentPseudoThrottledTotal = 0;
	
	public void putBandwidth(int bytes) {
		synchronized(throttleLock) {
			currentPseudoThrottledTotal += bytes;
		}
	}
	
    protected final void throttleConnections(int bytesRead, int throttledBytesRead, int pseudoThrottledBytesRead) {
		if(bw == null) return;
		boolean logDEBUG = Core.logger.shouldLog(Logger.DEBUG);
		if(bytesRead > 0) {
			if(logDEBUG)
				Core.logger.log(this, "Bytes moved total this loop: "+
								bytesRead+", bytes that need throttling: "+
								throttledBytesRead+", pseudo-throttled: "+
								pseudoThrottledBytesRead, Logger.DEBUG);
		}
		long now = System.currentTimeMillis();
		if(bytesRead < 0 || throttledBytesRead < 0 || 
		   pseudoThrottledBytesRead < 0) 
			throw new IllegalArgumentException("something negative this way comes");
		synchronized(throttleLock) {
			currentPseudoThrottledTotal+=pseudoThrottledBytesRead;
		}
		if(logDebug && pseudoThrottledBytesRead > 0)
			Core.logger.log(this, "Added "+pseudoThrottledBytesRead+" for a "+
							"total of "+currentPseudoThrottledTotal+" bytes "+
							"waiting (pseudothrottled)", Logger.DEBUG);
		if(throttledBytesRead == 0) {
			return;
		}
		synchronized(throttleLock) {
			throttledBytesRead += currentPseudoThrottledTotal;
			currentPseudoThrottledTotal = 0;
		}
		if(reregisterThrottledTime > System.currentTimeMillis())
			Core.logger.log(this, "throttleConnections("+bytesRead+","+
							throttledBytesRead+") called BEFORE LAST THROTTLE "+
							"EXPIRED!: now="+now+", reregisterThrottledTime="+
							reregisterThrottledTime, Logger.ERROR);
		if(throttledBytesRead > 0) {
			int sleepTime = bw.chargeBandwidthAsync(throttledBytesRead);
			if(sleepTime > 0) {
				now = System.currentTimeMillis();
				reregisterThrottledTime = sleepTime + now;
				Core.logger.log(this, "Unregistering bwlimited sockets "
								+" until "+reregisterThrottledTime+" (at "+
								now+" ("+sleepTime+" ms for "+
								throttledBytesRead+" bytes)",
								Logger.MINOR);
				throttling = true;
				// Now iterate through registered keys, and disable
				// those which belong to throttled connections
				Set allKeys = sel.keys();
				Iterator it = allKeys.iterator();
				int deregistered = 0;
				while(it.hasNext()) {
					SelectionKey curKey = 
						(SelectionKey)(it.next());
					if(!curKey.isValid()) {
						Core.logger.log(this, "Invalid "+curKey+"("+curKey.channel()+","+curKey.attachment()+" on selector in throttleConnections, ignoring", Logger.DEBUG);
						onInvalidKey(curKey);
						continue;
					}
					SocketChannel sc = (SocketChannel)(curKey.channel());
					if(sc == null || (!sc.isOpen()) || (!sc.isConnected())) {
						Core.logger.log(this, "Closing "+sc+
										" ("+curKey.attachment()+")",
										Logger.DEBUG);
						queueClose(((SocketChannel)(curKey.channel())), 
								   (NIOCallback)(curKey.attachment()));
						continue;
					}
					if(shouldThrottle(curKey.attachment())) {
						SocketChannel channel = 
							(SocketChannel)(curKey.channel());
						ChannelAttachmentPair pair =
							new ChannelAttachmentPair(channel, 
													  curKey.attachment());
// 						Core.logger.log(this, "Deregistering "+pair,
// 										Logger.DEBUG);
						curKey.cancel();
						synchronized(throttleLock) {
							throttleDisabledQueue.add(pair);
							throttleQueueLength = throttleDisabledQueue.size();
							deregistered++;
						}
						Core.logger.log(this, "Deregistered "+
										curKey.attachment(), Logger.DEBUG);
					}
				}
				if(logDEBUG)
					Core.logger.log(this, "Deregistered "+deregistered+
									" keys, TDQ.size="+
									throttleDisabledQueue.size(),
									Logger.DEBUG);
			}
		}
	}
	
	protected void onInvalidKey(SelectionKey key) {
		// Do nothing by default
	}
	
	protected  boolean shouldThrottle(Object o) {
		NIOCallback cb = ((NIOCallback)(o));
		boolean b = cb.shouldThrottle();
		return b;
	}
	
	protected abstract int myKeyOps();
	
	public void onClosed(SelectableChannel sc) {
		if(sc == null) throw new NullPointerException();
		synchronized(throttleLock) {
			// FIXME: linear scaling with number of disabled
			// connections (just like everything else here :( ).
			for(int i=0;i<throttleDisabledQueue.size();i++) {
				ChannelAttachmentPair current =
					(ChannelAttachmentPair)(throttleDisabledQueue.
											elementAt(i));
				if(current.channel == sc) {
					throttleDisabledQueue.removeElementAt(i);
					throttleQueueLength = throttleDisabledQueue.size();
					break;
				}
			}
		}
	}
	
	public void register(SelectableChannel ch, Object attachment) {
		synchronized(dontReregister) {
			dontReregister.remove(ch);
		}
		super.register(ch, attachment);
	}
	
    /**
     * @return true if the pair should be registered NOW, false if later
     */
    public boolean shouldRegister(ChannelAttachmentPair c) {
	synchronized(throttleLock) {
	    if(!throttling) return true;
	    SocketChannel chan = (SocketChannel)(c.channel);
	    if(chan == null) return true;
	    Socket sock = chan.socket();
	    tcpConnection con = (tcpConnection) // FIXME: should pass around tcpConns, not look them up every time
			(tcpConnection.getConnectionForSocket(sock));
		if(con == null) {
			if(!chan.isOpen()) return true;
			if(!chan.isConnected()) return true;
			Core.logger.log(this, "CANNOT FIND CONNECTION FOR OPEN PAIR "+
							c, new Exception("grrr"), Logger.ERROR);
			return true;
		}
	    if(con.shouldThrottle()) return false;
	    return true;
	}
    }
}
