/* -*- Mode: java; c-basic-indent: 4; tab-width: 4 -*- */
package freenet.transport;
//QUESTION: does this belong in this package?

import java.nio.channels.*;
import java.nio.ByteBuffer;
import freenet.SelectorLoop;
import freenet.Connection;
import freenet.support.io.Bandwidth;

// For logging
import freenet.Core;
import freenet.support.Logger;

import java.net.Socket;
import java.util.*;
import java.io.IOException;

/**
 * a loop that reads and processes message headers.
 * for now this is just the code I had written before
 * taken to its own class.  Parsing of fieldsets is yet
 * to be implemented.
 */

public final class ReadSelectorLoop extends ThrottledSelectorLoop {
	
	protected Map bufferMap; //TODO: contemplate the miniscule probability that a
	//weak map would be better here.
	
	private final LinkedList maintenanceQueue;

	//this needs to be taken from the settings.. wide guess is 2K
	//public static final int BUFFER_SIZE=2048;
	
	/*this is the maximum number of channels that can be active at any single
	  atom of time.  How much is an atom?  As small as it can be I guess.
	  NOTE: since this code will be entered a lot, I'd rather allocate more memory
	  needed on startup rather than do it on every entry.
	  This and the above parameters need to be fine tuned, because they will practically
	  grab BUFFER_SIZE*MAX_CONC_CHANNELS memory, and in most cases less than 10% of that 
	  will be used.  We can't however ignore those users on 100MBit connections ;-)) */
	protected static final int MAX_CONC_CHANNELS=20;
	
	public ReadSelectorLoop(Bandwidth bw) throws IOException{
		
		super(bw);
		//create the buffer stuff
		bufferMap = new HashMap(MAX_CONC_CHANNELS);
	//	buffers = new ByteBuffer[MAX_CONC_CHANNELS];
		maintenanceQueue = new LinkedList();
		
	//	for (int i =0;i<MAX_CONC_CHANNELS;i++)
	//		buffers[i] = ByteBuffer.allocateDirect(BUFFER_SIZE);
	}
	
	public ReadSelectorLoop() throws IOException{
		
		super();
		//create the buffer stuff
		bufferMap = new HashMap(MAX_CONC_CHANNELS);
	//	buffers = new ByteBuffer[MAX_CONC_CHANNELS];
		maintenanceQueue = new LinkedList();
		
	//	for (int i =0;i<MAX_CONC_CHANNELS;i++)
	//		buffers[i] = ByteBuffer.allocateDirect(BUFFER_SIZE);
	}
	
	/**
	 * resets the buffers to prepare for the next loop
	 */
// 	private final void resetBuffers() {
// 		Iterator i = bufferMap.entrySet().iterator();
// 		while(i.hasNext()) {
// 			Map.Entry e = (Map.Entry)(i.next());
// 			ByteBuffer current = (ByteBuffer)e.getValue();
// 			current.clear();
// 			i.remove();
// 		}
// 		//this should not be necessary, but lets do it just in case
// 		bufferMap.clear();
// 	}
	
	/**
	 * override this to clean up the buffers
	 * and do bandwith throttling
	 */
	protected final void beforeSelect() {
		
		
		//empty the buffers
	//	resetBuffers();
		bufferMap.clear();
		
		// Cancel keys etc, for throttleBeforeSelect
		boolean success = false;
		while(!success) {
			try {
				success = mySelect(0);
			} catch (IOException e) {
				Core.logger.log(this, "selectNow() failed in RSL.beforeSelect(): "+e,
								e, Logger.ERROR);
			}
		}
		//make sure no message got stuck behind a trailing field
		
		while (maintenanceQueue.size() > 0) {
			NIOReader current;
			//process could take a while, so lock just this
			synchronized(maintenanceQueue) {
				current = (NIOReader)maintenanceQueue.removeFirst();
			}
			current.process(null);
		}
		
		throttleBeforeSelect();
		
	}
	
	public final void scheduleMaintenance(NIOReader cb) {
		if(logDebug)
			Core.logger.log(this, "Scheduling maintenance on "+cb, 
							new Exception("debug"), Logger.DEBUG);
		synchronized (maintenanceQueue) {
			maintenanceQueue.addLast(cb);
		}
	}
	
	/**
	 * we're missing reads.  This will try and fix it
	 */
	protected final void fixKeys() {
// 		Set bigSet = sel.keys();
// 		//Core.logger.log(this,"size of bigSet "+bigSet.size()
// 		//			+ " size of smallSet " + currentSet.size(),Logger.NORMAL);
// 		Iterator i = bigSet.iterator();
		
// 		while (i.hasNext()) {
// 			SelectionKey current = (SelectionKey) i.next();
			
// 			if (current.isValid() && current.isReadable())  {
// 				// Don't check open, we need to see them as readable and
// 				// then get the -1 read
// 				if (logDebug)Core.logger.log(this, "fixKeys added "+
// 											 current.channel()+":"+
// 											 current.attachment(), 
// 											 Logger.DEBUG);
// 				//Core.logger.log(this,"told you so!",Logger.ERROR);
// 				currentSet.add(current);
// 			}
			
// 		}
		
// 		//Core.logger.log(this,"size of small set after fixing " + currentSet.size(),Logger.NORMAL);
		//Core.logger.log(this,"size of small set after fixing " + currentSet.size(),Logger.NORMAL);*/
	}
	
	/**
	 * a screwed channel is marked as available for read, but
	 * a read() call on it returns -1.  Therefore...
	 */
	protected final boolean inspectChannels() {
		int screwedSelections = 0;
		//assume currentSet has been initialized
		Iterator i = currentSet.iterator();
		
		boolean noneWorking = true;
		
		int throttledBytesRead = 0;
		int bytesRead = 0;
		int pseudoThrottledBytesRead = 0;
		int j =0;
		boolean noThrottled = (System.currentTimeMillis() < 
							   reregisterThrottledTime);
		
		while (i.hasNext()) {
			SelectionKey current = (SelectionKey)i.next();
			//if (!(current.isValid() && current.isReadable() && current.channel().isOpen())) continue;
			NIOReader nc = (NIOReader)current.attachment();
			if(nc == null) continue;
			ByteBuffer bumper = nc.getBuf();
			SocketChannel sc = (SocketChannel)current.channel();
// 			if (logDebug) Core.logger.log(this," checking channel "+sc.toString(),Logger.DEBUG);
			int size=0;
			boolean shouldThrottle = nc.shouldThrottle();
			try {
				synchronized(bumper) {
					if(!current.isValid()) {
						if (logDebug)Core.logger.log(this, "Channel invalid: "+bumper+":"+
										sc+":"+nc+" ("+iteration+")",
										Logger.DEBUG);
						size = 0;
						continue;
					} else
					if (noThrottled && shouldThrottle) {
						if (logDebug)Core.logger.log(this, "Ignored throttled "+current,
										Logger.DEBUG);
						// It will be put back onto the throttled queue later
						// No need to cancel
						size = 0;
						continue;
					} else if(bumper.limit() == bumper.capacity()) {
						Core.logger.log(this, "BUFFER FULL ("+current+":"+
										current.isValid()+") for "+
										bumper+":"+
										sc+":"+nc+" ("+iteration+")",
										Logger.ERROR);
						size = 0;
 					} else if (!current.isReadable()) {
 						if(logDebug)Core.logger.log(this, "Not readable: "+current,
 										Logger.DEBUG);
 						size = 0;
					} else {
						if (logDebug)logBumper(bumper, sc, nc, 0);
						bumper.position(bumper.limit());
						if(logDebug) logBumper(bumper, sc, nc, 1);
						bumper.limit(bumper.capacity());
						if (logDebug)logBumper(bumper, sc, nc, 2);
						try {
							size = sc.read(bumper);
							if(size == 0) {
								Core.diagnostics.occurrenceCounting("readinessSelectionScrewed",1);
								bumper.flip();
								screwedSelections++;
								sel.selectedKeys().remove(current);
								continue;
							}
						} catch (ClosedChannelException e) {
							if(logDebug)
								Core.logger.log(this, "Channel closed: "+e+" for "+current,
												e, Logger.DEBUG);
							SelectionKey k = sc.keyFor(sel);
							k.attach(null);
							k.cancel();
							queueClose(sc, nc);
							nc.unregistered(); // see below re sequence
							continue;
						} catch (IOException e) {
							int prio = Logger.MINOR;
							if((e.getMessage() != null) &&
							   ((e.getMessage().indexOf("pipe") >= 0) ||
								(e.getMessage().indexOf("peer") >= 0) ||
								(e.getMessage().indexOf("timed out") >= 0))) {
								if(e.getMessage().trim().
								   equalsIgnoreCase("Connection reset by peer"))
									Core.diagnostics.occurrenceCounting("connectionResetByPeer", 1);
								prio = Logger.DEBUG;
							}
							if(prio != Logger.DEBUG || 
							   logDebug)
								Core.logger.log(this, "IOException processing "+
												nc+": "+e+ ", bytes read: "+size, e, prio);
								logBumper(bumper,sc,nc,3);
							size = -1;
						}
						if (logDebug)logBumper(bumper, sc, nc, 4);
						bumper.flip();
						if (logDebug)logBumper(bumper, sc, nc, 5);
					}
				}
			} catch (Throwable e) {
				e.printStackTrace();
				Core.logger.log(this, "Unexpected throwable reading data for "+
								nc+": "+e, e, Logger.NORMAL);
				size = -1; // try unregistering it...
			}
			if (size == -1) {
				//TODO: log that this channel got closed.
				// and mark its Connection object as closed. (that'll be tricky)
				if(logDebug)
					Core.logger.log(this, "Closed (read -1): "+current,
									Logger.DEBUG);
				SelectionKey k = sc.keyFor(sel);
				k.attach(null);
				k.cancel();
				
				// queueClose BEFORE notifying unregistration.
				// So that if we wait on unregistration, and then check closure,
				// we get the right sane answer.
				queueClose((SocketChannel)sc, nc);
				nc.unregistered();
			} else if (size > 0 || (bumper.limit() > 0)) {
				//do not call process() if nothign was read
				//this actually is an error in fixkeys
				if(size > 0) {
					bytesRead += (size+OVERHEAD);
					if(shouldThrottle)
						throttledBytesRead += (size+OVERHEAD);
					else if (nc.countAsThrottled())
						pseudoThrottledBytesRead += (size+OVERHEAD);
				}
				if(logDebug) Core.logger.log(this, "putting "+sc+":"+bumper+
											 " on bufferMap:"+size+":"+
											 (bumper.limit()), Logger.DEBUG);
				bufferMap.put(sc,bumper);
				noneWorking=false;
			}
			
			/*if(size == 0) { //this is happening waaay too often
				Core.logger.log(this, "Readiness selection screwed - 0 byte "+
								"read: "+current+":"+sc+":"+nc, Logger.MINOR);
			}*/
			/*else 
			  ok so fixkeys is screwed somehow...
			  Core.logger.log(this,"rsl.fixkeys screwed",Logger.ERROR);*/
			j++;
		}//they *should* throw exceptions, but they don't.  just in case, lets print.
		if(bw != null) {
			throttleConnections(bytesRead, throttledBytesRead,
								pseudoThrottledBytesRead);
		}
		if(logDebug)
			Core.logger.log(this," number of false positives "+
							screwedSelections,Logger.DEBUG);
		return noneWorking;
	}
	
	static Object staticIterationLock = new Object();
	static int staticIteration = 0;
	int iteration = 0;
	
	private final void logBumper(ByteBuffer bumper, SelectableChannel chan, 
						   NIOReader nc, int stage) {
		synchronized(staticIterationLock) {
			iteration++;
			staticIteration++;
			if(logDebug)
				Core.logger.log(this, "Reading ("+stage+") for "+
								nc+" : "+chan+": "+bumper+":("+
								bumper.position()+"/"+bumper.limit()+
								"/"+bumper.capacity()+") - iter "+
								iteration+":"+staticIteration,
								Logger.DEBUG);
		}
	}
	
	/**
	 * this is where we parse the fieldsets
	 * will finish it later
	 */
	protected final boolean processConnections() {
		boolean success = true;
		try {
			Iterator i = bufferMap.keySet().iterator();
			while (i.hasNext()) {
				SocketChannel chan = (SocketChannel)i.next();
				if(logDebug) Core.logger.log(this, "processConnections: "+chan,
											 Logger.DEBUG);
				SelectionKey k = chan.keyFor(sel);
				if(k == null) {
					Core.logger.log(this, "null key for "+chan,
									Logger.NORMAL);
					continue;
				}
				NIOReader nc = (NIOReader)(k.attachment());
				ByteBuffer b = nc.getBuf();
				int status = 1;
				try {
					status = nc.process(b);
				} catch (Throwable t) {
					Core.logger.log(this, "Caught throwable "+t+" processing "+
									nc, t, Logger.NORMAL);
					status = -1;
				}
				if(status == -1) {
					if(logDebug)
						Core.logger.log(this, "Closing connection "+chan+":"+nc+
										" (process returned -1)", Logger.DEBUG);
					k.attach(null);
					k.cancel();
					nc.unregistered();
					queueClose((SocketChannel)chan,nc);
				} else if (status == 0) {
					if (logDebug) Core.logger.log(this, "Cancelling "+nc+":"+
												  b+"(returned 0)",
												  Logger.DEBUG);
					k.cancel();
					synchronized(dontReregister) {
						dontReregister.add(chan);
					}
					if (logDebug)Core.logger.log(this, "Cancelled "+nc+": "+
												 k.isValid()+": "+
												 k, Logger.DEBUG);
				} else {
					// Good
				}
			}
		} catch (Throwable t) {
			t.printStackTrace();
			success=false;
			Core.logger.log(this, "Something broke in RSL.processConnections(): "+t, t, Logger.ERROR);
		}
		
		return success;
	}
	
	protected final int myKeyOps() {
		return SelectionKey.OP_READ;
	}
	
	/**
	 * the run method.  This is the place to add more init stuff
	 * NOTE: perhaps we want to catch exceptions here.  But for now 
	 * I like to print everything on stderr.
	 */
	public final void run() {
		
		loop();
	}
	
	//TODO: need to decide what happens when we close the selector this way.
	public final void close(){
		closeCloseThread();
		
	}
}
