package freenet.thread;
import java.io.PrintWriter;

/**
 * This is more convenient than using a ThreadManager for some purposes.
 * It is generally assumed that thread pooling is taking place
 * @author tavin
 */
public interface ThreadFactory {

    /**
     * @return  the desired maximum number of threads for the factory.
     * It should be able to overflow, but that is not desired.
     */
    int maximumThreads();

    /**
     * @return  the number of available threads at this instant
     */
    int availableThreads();

    /**
     * @return  the number of currently executing jobs
     */
    int activeThreads();

    /**
     * @param r      the job to run
     */
    Thread getThread(Runnable r);

}


