package freenet.support.servlet;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

/**
 * Simple implementation.
 *
 * @author oskar
 */

public final class ServletInputStreamImpl extends ServletInputStream {

    private final InputStream in;

    public ServletInputStreamImpl(InputStream in) {
	if(in == null) throw new IllegalArgumentException("in must not be null!");
        this.in = in;
    }

    public final int read() throws IOException {
        return in.read();
    }

    public final int read(byte[] b) throws IOException {
        return in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return in.read(b, off, len);
    }

    public final void close() throws IOException {
        in.close();
    }

    public final int available() throws IOException {
        return in.available();
    }

    public final boolean markSupported() {
        return in.markSupported();
    }

    public final void mark(int rl) {
        in.mark(rl);
    }

    public final void reset() throws IOException {
        in.reset();
    }

    public final void skip(int n) throws IOException {
        in.skip(n);
    }
}


