package freenet.support.servlet;

import freenet.config.Params;
import javax.servlet.*;
import java.util.Enumeration;

public class ServletConfigImpl implements ServletConfig {

    protected ServletContext context;
    protected String servletName;
    protected Params initParams;
    
    public ServletConfigImpl(ServletContext context, String servletName,
                             Params initParams) {
        this.context = context;
        this.servletName = servletName;
        this.initParams  = initParams;
    }

    public ServletContext getServletContext() {
        return context;
    }
    
    public String getServletName() {
        return servletName;
    }
    
    public String getInitParameter(String name) {
        return initParams.getString(name, true);
    }
    
    public Enumeration getInitParameterNames() {
        return initParams.keys();
    }
}
