package freenet.support.io;
import freenet.Core;
import java.io.*;
import freenet.diagnostics.*;

/**
 * An OutputStream which reports the amount of data sent through it to a Diagnostics
 *
 * @author <a href="mailto:coates@windmail.net">Benjamin Coates</a>
 */

public class DiagnosticsOutputStream extends FilterOutputStream {
	private static Diagnostics d = Core.diagnostics;
	private static String countingName = "outputBytes";
	
    public DiagnosticsOutputStream(OutputStream out) {
        super(out);
    }
    
  /**
   * Write a single byte to this OutputStream.
   * 
   * @param b the byte to write.
   * @throws IOException if an I/O error occurs on the OutputStream.
   */
        
    public void write(final int b) throws IOException {
        out.write(b);
        d.occurrenceCounting(countingName, 1);
    }
    
  /**
   * Write an array of bytes to this OutputStream.
   *
   * @param data the bytes to write.
   * @param offset the index in the array to start at.
   * @param totalLength the number of bytes to write.
   * @throws IOException if an I/O error occurs on the OutputStream.
   */
  
    public void write(byte[] data, int offset, int totalLength)
        throws IOException
    {
    	out.write(data, offset, totalLength);
		d.occurrenceCounting(countingName, totalLength);
    }
}