package freenet.support.io;
import java.io.*;

/**
 * This extends ReadInputStream with the difference that readTo() results
 * that are only whitespace or start with the comment character are ignored.
 * Except that they are checked for the provided substring, and if so,
 * a boolean is set
 * 
 * @author amphibian
 */
public class CommentedScanningReadInputStream extends ReadInputStream {

    /**
     * The characters that are considered comments.
     */
    public final String comment;
    public final String scanFor;
    protected boolean tripped = false;

    /**
     * @param i        The inputstream to read from.
     * @param comment  The characters that denote comments if they appear at
     *                 the beginning of a line (not counting whitespace);
     */
    public CommentedScanningReadInputStream(InputStream i, String comment, String scanFor) {
        super(i);
        this.comment = comment;
	this.scanFor = scanFor;
    }
    
    public boolean tripped() {
	return tripped;
    }
    
    public String readTo(char ends) throws IOException, EOFException {
        String s;
        while(true) {
            s = super.readTo(ends);
	    if(s.trim().equals("")) continue;
	    int x = comment.indexOf(s.trim().charAt(0));
	    if((!tripped) && (x != -1)) {
		if(s.length()>1) {
		    if(s.substring(1).indexOf(scanFor) != -1)
			tripped = true;
		}
		continue;
	    }
	    return s;
        }
    }

    public String readToEOF(char ends) throws IOException, EOFException {
        String s;
        while(true) {
            s = super.readToEOF(ends);
	    if(s.trim().equals("")) continue;
	    int x = comment.indexOf(s.trim().charAt(0));
	    if((!tripped) && (x != -1)) {
		if(s.length()>1) {
		    if(s.substring(1).indexOf(scanFor) != -1)
			tripped = true;
		}
		continue;
	    }
	    return s;
        }
    }
}


