package freenet.support;

import freenet.*;

import java.io.*;
import java.net.*;
import java.util.*;

/*
 *  This code is part of fproxy, an HTTP proxy server for Freenet.
 *  It is distributed under the GNU Public Licence (GPL) version 2.  See
 *  http://www.gnu.org/ for further details of the GPL.
 */
/**
 *  Description of the Class
 *
 * @author     ian
 * @created    August 28, 2002
 */
public class SpyOutputStream extends FilterOutputStream {
  String prefix = "";
  TempFileBucket tfb = null;
  //private final static boolean vociferous = false;

  /**
   *  Description of the Method
   *
   * @param  text  Description of the Parameter
   */
  private void println(String text) {
      //if (vociferous) {
      if(freenet.Core.logger.shouldLog(freenet.Core.logger.DEBUG))
	  freenet.Core.logger.log(this, text, Logger.DEBUGGING);
      //
  }


  /**
   *  Description of the Method
   *
   * @exception  IOException  Description of the Exception
   */
  private final void checkValid() throws IOException {
    if (tfb.isReleased()) {
      throw new IOException("Attempt to use a released TempFileBucket: " + prefix);
      //throw new TrackingIOE("Attempt to use a released TempFileBucket: " + prefix);
    }
  }


  /**
   * Constructor for the SpyOutputStream object
   *
   * @param  tfb              Description of the Parameter
   * @param  pref             Description of the Parameter
   * @exception  IOException  Description of the Exception
   */
  public SpyOutputStream(TempFileBucket tfb, String pref) throws IOException {
    super(null);
    OutputStream tmpOut = null;
    try {
      this.prefix = pref;
      this.tfb = tfb;
      checkValid();
      tmpOut = tfb.getRealOutputStream();
      out = tmpOut;
    } catch (IOException ioe) {
      //ioe.printStackTrace();
      println("SpyOutputStream ctr failed!: " + ioe.toString());
      try {
        if (tmpOut != null) {
          tmpOut.close();
        }
      } catch (Exception e0) {
        // NOP
      }
      println("SpyOutputStream ctr failed!: " + ioe.toString());
      throw ioe;
    }
    println("Created new OutputStream");
  }


  ////////////////////////////////////////////////////////////
  // FilterOutputStream implementation
  /**
   *  Description of the Method
   *
   * @param  b                Description of the Parameter
   * @exception  IOException  Description of the Exception
   */
  public void write(int b) throws IOException {
    synchronized (tfb) {
//       println(".write(b)");
      checkValid();
      out.write(b);
    }
  }

  /**
   *  Description of the Method
   *
   * @param  buf              Description of the Parameter
   * @exception  IOException  Description of the Exception
   */
  public void write(byte[] buf) throws IOException {
    synchronized (tfb) {
//       println(".write(buf)");
      checkValid();
      out.write(buf);
    }
  }

  /**
   *  Description of the Method
   *
   * @param  buf              Description of the Parameter
   * @param  off              Description of the Parameter
   * @param  len              Description of the Parameter
   * @exception  IOException  Description of the Exception
   */
  public void write(byte[] buf, int off, int len) throws IOException {
    synchronized (tfb) {
//       println(".write(buf,off,len)");
      checkValid();
      out.write(buf, off, len);
    }
  }


  /**
   *  Description of the Method
   *
   * @exception  IOException  Description of the Exception
   */
  public void flush() throws IOException {
    synchronized (tfb) {
      println(".flush()");
      checkValid();
      out.flush();
    }
  }


  /**
   *  Description of the Method
   *
   * @exception  IOException  Description of the Exception
   */
  public void close() throws IOException {
    synchronized (tfb) {
      println(".close()");
      checkValid();
      out.close();
      if (tfb.streams.contains(out)) {
        tfb.streams.removeElement(out);
      }
    }
  }
}

