package freenet.support;

import java.io.*;

public class PipedBucket implements Bucket {
    
    private PipedInputStream in;
    private PipedOutputStream out;

    private long len;
    
    static public void main(String[] args) throws IOException
    {
      PipedBucket pb=new PipedBucket();
      InputStream i=pb.getInputStream();
      OutputStream o=pb.getOutputStream();
      BufferedReader br=new BufferedReader(new InputStreamReader(i));
      PrintWriter pw=new PrintWriter(o);
      pw.println("hi");
      pw.flush();
      String s=br.readLine();
      System.out.println(s);
    }

    public PipedBucket() {
        this(-1);
    }

    public PipedBucket(int len) {
        this.len = len;
        resetWrite();
    }

    /**
     * Returns an OutputStream that is used to put data in this Bucket.
     **/
    public OutputStream getOutputStream() throws IOException {
        if (out == null) throw new IOException("failed to set up piped streams");
        return out;
    }

    /**
     * Returns an InputStream that reads data from this Bucket. If there is
     * no data in this bucket, null is returned.
     **/
    public InputStream getInputStream() throws IOException {
        if (in == null) throw new IOException("failed to set up piped streams");
        return in;
    }

    /**
     * If resetWrite() is called on the object, the next getOutputStream
     * should overwrite any other data in the bucket from the beginning,
     * otherwise it should append it.
     **/
    public void resetWrite() {
        in = new PipedInputStream();
        try {
            out = new PipedOutputStream(in);
        }
        catch (IOException e) {
            in  = null;
            out = null;
        }
    }

    /** @return a fictitious length
      */
    public long size() {
        return len;
    }

    public String getName() {
        return "Piped bucket";
    }

}

