package freenet.node.states.announcement;
import freenet.*;
import freenet.node.*;
import freenet.message.*;
import freenet.support.Logger;
import java.util.Enumeration;

/**
 * Waiting for a Execute on a reply
 */

public class ExecutePending extends ExecuteHandler {


    public ExecutePending(ReplyPending rp, byte[] returnVal, NoExecute ne) {
        super(rp, ne, returnVal);
    }

    public String getName() {
        return "Announcement Execute Pending";
    }

    public State received(Node n, MessageObject mo) throws StateException {
        // we only want messages from origRec
        if (mo instanceof Message &&
            !origRec.equalsIdent(((Message) mo).peerIdentity())) {
            
            throw new BadStateException("Got message " 
                                        + mo.getClass().getName() +
                                        " from wrong peer");
        } 

        return super.received(n, mo);
    }


    public State receivedMessage(Node n, NoExecute ne) 
        throws BadStateException {
        
        if (ne != this.ne) {
            throw new BadStateException("Got the wrong NoExecute message");
        }
	n.logger.log(this, "ExecutePending got NoExecute "+ne,
		     Logger.NORMAL);
        try {
            n.sendMessage(new QueryAborted(id), lastAddr);
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send QueryAborted after no Execute",
                         e, Logger.DEBUG);
        }

        try {
            n.sendMessage(
                new AnnouncementFailed(id, AnnouncementFailed.NO_EXECUTE),
                origRec);
           
        } catch (CommunicationException e) {
            n.logger.log(this, 
                         "Failed to send AnnouncementFailed after no Execute",
                         e, Logger.DEBUG);
        }

        return new AnnouncementDone(this);
    }

    public State receivedMessage(Node n, QueryAborted qr) {

        n.logger.log(this, "Announcement Aborted by previous node",
                     Logger.DEBUG);

        ne.cancel();
        try {
            n.sendMessage(qr, lastAddr);
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send QueryAborted after no Execute",
                         e, Logger.DEBUG);
        }

        return new AnnouncementDone(this);
    }

    public State receivedMessage(Node n, AnnouncementExecute ae) 
        throws StateException {
        // We are in business!

        Key k = executeAnnounce(n, ae);

        if (k != null) {
            NoComplete nc = new NoComplete(id);
            CompletePending cp = new CompletePending(this, k, nc);

            try {
                sendMessage(n, lastAddr, ae, ae.getValueList());
                n.schedule(getTime(hopsToLive), nc);
                return cp;
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to send AnnouncementComplete - "
                             + "pretending like I never got it back.",
                             e, n.logger.MINOR);
                // well, we aren't going to get a Complete, so...
                return cp.received(n, nc);
            }
        } else {
            QueryAborted qa = new QueryAborted(id);
            AnnouncementFailed af = 
                new AnnouncementFailed(id,
                                       AnnouncementFailed.CORRUPT_EXECUTE);
            try {
                n.sendMessage(qa, lastAddr);
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to send QueryAborted after bad AE.",
                             n.logger.MINOR);
            }
            try {
                n.sendMessage(af, origRec);
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to send AnnouncementFailed after " 
                             + "bad AE.", n.logger.MINOR);
            }

            return new AnnouncementDone(this);
        }
    }
}
