package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.message.client.*;
import freenet.node.ds.FSDataStore;
import freenet.support.Fields;

public class NewHello extends NewClientRequest {

    public NewHello(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public final String getName() {
        return "New Client Hello";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof ClientHello))
            throw new BadStateException("expecting ClientHello");
        FieldSet fs = new FieldSet();
        fs.add("Node", Version.getVersionString());
        fs.add("Protocol", "1.2");
	fs.add("MaxFileSize", Fields.longToString(((FSDataStore)(n.ds)).maxDataSize));
	if (Version.highestSeenBuild > Version.buildNumber) {
            fs.add("HighestSeenBuild", ""+Version.highestSeenBuild);
	}
        sendMessage(new NodeHello(id, fs));
        return null;
    }
}

