package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.message.client.*;
import freenet.support.*;
import freenet.client.*;
import freenet.crypt.*;
import java.io.*;

public class NewGenerateSHA1 extends NewClientRequest {

    public NewGenerateSHA1(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public String getName() {
        return "New Client GenerateSHA1";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof GenerateSHA1)) {
            throw new BadStateException("expecting GenerateSHA1");
        }

        GenerateSHA1 gs = (GenerateSHA1) mo;
        
        long dlen = gs.getDataLength();
        long mlen = gs.getMetadataLength();
        try {
            if (mlen != 0) {
                // We don't expect any metadata.
                throw new RuntimeException("GenerateSHA1 got unexpected metadata.");
            }    
            byte[] hash = Util.hashStream(SHA1.getInstance(), 
					  gs.getDataStream(), dlen);
            FieldSet fs = new FieldSet();
            fs.put("SHA1", freenet.support.Fields.bytesToHex (hash,0,hash.length));
            sendMessage(new Success(id, fs));
        }
        catch (Exception e) {
            n.logger.log(this, "GenerateSHA1 failed", e, Logger.MINOR);
            sendMessage(new Failed(id, e.getMessage()));
        }
        return null;
    }
}


