package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.message.client.*;
import freenet.support.*;
import freenet.client.*;
import freenet.crypt.*;
import java.io.*;

public class NewGenerateCHK extends NewClientRequest {

    public NewGenerateCHK(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public String getName() {
        return "New Client GenerateCHK";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof GenerateCHK)) {
            throw new BadStateException("expecting GenerateCHK");
        }
        GenerateCHK gchk = (GenerateCHK) mo;
        
        long dlen = gchk.getDataLength();
        long mlen = gchk.getMetadataLength();
            
        Bucket data = null;
        try {
            // first, fully read the data from the client
            data = n.bf.makeBucket(dlen);
            OutputStream out = data.getOutputStream();
            try { copyFully(gchk.getDataStream(), out, dlen); }
            finally { out.close(); }

            ClientCHK chk = new ClientCHK();
        
            String cipher = gchk.otherFields.get("Cipher");
            if (cipher != null) chk.setCipher(cipher);
            
            long tmpLen;
            tmpLen = chk.getPaddedLength(dlen);
            tmpLen = chk.getTotalLength(tmpLen, chk.getPartSize(tmpLen)); 
            
            Bucket ctBucket = n.bf.makeBucket(tmpLen);
            try {
                // chk.encode() returns an InputStream that we must close
                chk.encode(data, mlen, ctBucket).close();
            }
            finally {
                n.bf.freeBucket(ctBucket);
            }
                
            FieldSet fs = new FieldSet();
            fs.put("URI", chk.getURI().toString());
            sendMessage(new Success(id, fs));
        }
        catch (Exception e) {
            n.logger.log(this, "GenerateCHK failed", e, Logger.MINOR);
            sendMessage(new Failed(id, e.getMessage()));
        }
        finally {
            try {
                if (data != null) n.bf.freeBucket(data);
            }
            catch (IOException e) {}
        }
        
        return null;
    }
}


