package freenet.node.http.infolets;
import freenet.node.http.Infolet;
import freenet.node.http.SimpleAdvanced_ModeUtils;
import freenet.support.LoggerHook;
import freenet.support.BufferLoggerHook;
import freenet.support.BufferLoggerHook.LogEntry;
import freenet.support.Logger;
import freenet.node.Node;
import freenet.Core;
import java.io.PrintWriter;
import java.util.Date;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;

public class LoggerInfolet extends Infolet {

    public static final int BUFFER_SIZE = 20;

    private static final SimpleDateFormat sdf = 
        new SimpleDateFormat("HH:mm:ss");

    private BufferLoggerHook buffer;

    public String longName() {
        return "Recent logs";
    }
    
    public String shortName() {
        return "logs";
    }
    
	public boolean visibleFor(HttpServletRequest req){
		return SimpleAdvanced_ModeUtils.isAdvancedMode(req);
	}
    
    public void init(Node n) {
        LoggerHook[] hooks = n.logger.getHooks();
        for (int i = 0 ; i < hooks.length ; i++) {
            if (hooks[i] instanceof BufferLoggerHook &&
                ((BufferLoggerHook) hooks[i]).size() >= BUFFER_SIZE) {
                buffer = (BufferLoggerHook) hooks[i];
                break;
            }
        }
        if (buffer == null) { // still
            buffer = new BufferLoggerHook(BUFFER_SIZE);
            n.logger.addHook(buffer);
            n.logger.log(this, "No log buffer was found when starting log " +
                         "infolet.", n.logger.MINOR);
        }
    }

    public synchronized void toHtml(PrintWriter pw) {
        pw.println("<h3>Recently logged messages:</h3>\n");
        pw.println("<b>Priority legend: </b> <font color=\"#FF0000\">" + 
                   "Error</font>, <font color=\"#000000\">Normal</font>" + 
                   ", <font color=\"#060606\">Minor</font>, " + 
                   "<font color=\"#0000FF\">Debug</font><p>\n");
        pw.println("<table width=\"100%\"><tr><th>Time</th>" + 
                   "<th>Message</th><th>Exception</th></tr>\n");
        LogEntry[] le = buffer.getBuffer();

        for (int i = 0 ; i < le.length && i < BUFFER_SIZE; i++) {
            String color;
            switch (le[i].priority()) {
            case Logger.ERROR:
                color = "#FF0000";
                break;
            case Logger.NORMAL:
                color = "#000000";
                break;
            case Logger.MINOR:
                color = "#060606";
                break;
            default:
                color = "#0000FF";
            }
            
            StringBuffer sb = new StringBuffer(250);
            sb.append("<tr><td><font color=\"").append(color).append("\">");
            sb.append(sdf.format(new Date(le[i].time())));
            sb.append( "</font></td><td><font color=\"").append(color);
            sb.append("\">").append(le[i].message());
            sb.append("</font></td><td><font color=\"");
            sb.append(color).append("\">").append(le[i].exception());
            sb.append("</font></td></tr>");

            pw.println(sb.toString());
        }
        pw.println("</table>\n");
    }

}




