package freenet.node.http.infolets;
import freenet.node.http.Infolet;
import freenet.node.http.SimpleAdvanced_ModeUtils;
import freenet.node.Node;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.servlet.http.HttpServletRequest;

/**
 *  Description of the Class
 *
 * @author     ian
 * @created    September 4, 2002
 */
public class LoadStatsInfolet extends Infolet {

  Node n;


  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public String longName() {
    return "Network Load";
  }
  
  public boolean visibleFor(HttpServletRequest req){
	  return SimpleAdvanced_ModeUtils.isAdvancedMode(req);
  }


  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public String shortName() {
    return "loadstats";
  }


  /**
   *  Description of the Method
   *
   * @param  n  Description of the Parameter
   */
  public void init(Node n) {
    this.n = n;
  }


  /**
   *  Description of the Method
   *
   * @param  pw  Description of the Parameter
   */
  public void toHtml(PrintWriter pw) {
      // DO NOT lock LoadStats while waiting for network I/O!
      StringWriter ssw = new StringWriter(2048);
      PrintWriter ppw = new PrintWriter(ssw);
      n.loadStats.dumpHtml(ppw);
      ppw.flush();
      pw.println(ssw.toString());
  }

}

