package freenet.node.http.infolets;
import freenet.node.http.*;
import freenet.node.Node;
import freenet.diagnostics.Diagnostics;
import freenet.Version;
import freenet.support.servlet.*;
import freenet.Core;
import java.io.PrintWriter;

/**
 * This is the Infolet which is displayed by default
 *
 * @author     ian
 * @created    August 30, 2002
 */
public class GeneralInfolet extends Infolet {
  private Node node;

  HtmlTemplate titleBoxTemplate;


  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public String longName() {
    return "General Information";
  }


  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public String shortName() {
    return "general";
  }


  /**
   *  Description of the Method
   *
   * @param  n  Description of the Parameter
   */
  public void init(Node n) {
    try {
      titleBoxTemplate = HtmlTemplate.createTemplate("aqua/titleBox.tpl");
    } catch (java.io.IOException e) {
      ///BAD BOY!!!
    }
    node = n;
  }


  public void toHtml(PrintWriter pw) {
    StringBuffer sb = new StringBuffer(500);
    sb.append("From here you can view information about what is going ");
    sb.append("on inside your node.  Select from the options in the ");
    sb.append("menu to the left.");
    // reentrancy
    HtmlTemplate titleBoxTemplate = new HtmlTemplate(this.titleBoxTemplate);
    titleBoxTemplate.set("CONTENT", sb.toString());
    titleBoxTemplate.set("TITLE", "Node Information");
    titleBoxTemplate.toHtml(pw);
    sb = new StringBuffer(500);
    sb.append("<table>");
    sb.append("<tr><td nowrap>Node Version</td><td>" + Version.nodeVersion +
        "</td></tr>");
    sb.append("<tr><td nowrap>Protocol Version</td><td>" +
        Version.protocolVersion + "</td></tr>");
    sb.append("<tr><td nowrap>Build Number</td><td>" + Version.buildNumber +
        "</td></tr>");
    sb.append("<tr><td nowrap>CVS Revision</td><td>" + Version.cvsRevision +
        "</td></tr>");
    sb.append("</table>");
    titleBoxTemplate.set("TITLE", "Version Information");
    titleBoxTemplate.set("CONTENT", sb.toString());
    titleBoxTemplate.toHtml(pw);
    StringBuffer uptime = new StringBuffer();

    long deltat = (System.currentTimeMillis() - Node.startupTimeMs) / 1000;

    if (deltat < 60) {
      uptime.append("&nbsp;< 1 minute ");
    } else {
      long days = deltat / 86400l;
      deltat -= days * 86400l;
      long hours = deltat / 3600l;
      deltat -= hours * 3600l;
      long minutes = deltat / 60l;

      if (days > 0) {
        uptime.append(days).append(days == 1 ? " day" :
            " days").append(" ");
      }
      if (hours > 0) {
        uptime.append(hours).append(hours == 1 ? " hour" :
            " hours").append(" ");
      }
      uptime.append(" ").append(minutes).append(minutes == 1 ?
          " minute" :
          " minutes");
    }
    sb = new StringBuffer(500);
    sb.append("&nbsp;" + uptime);
    titleBoxTemplate.set("TITLE", "Uptime");
    titleBoxTemplate.set("CONTENT", sb.toString());
    titleBoxTemplate.toHtml(pw);

    sb = new StringBuffer(500);
    sb.append("<table>");
    sb.append("<tr><td nowrap>Current routingTime</td><td>"
         + (long) Core.diagnostics.getValue("routingTime", Diagnostics.MINUTE, Diagnostics.MEAN_VALUE) + "ms</td></tr>");

    // Thread load
    int jobs = node.activeJobs();
    int available = node.availableThreads();
    float f = node.estimatedLoad();
    // It's not just thread based.  There's also a hard
    // rate limit.
    boolean rejectingRequests = node.rejectingRequests();
    boolean rejectingConnections = node.rejectingConnections();

    if (jobs > -1) {
      String color = "black";
      String comment = "";
      if (rejectingConnections) {
        color = "red";
        comment = "<b>[Rejecting incoming connections and requests!]</b>";
      } else if (rejectingRequests) {
        color = "red";
        comment = "<b>[QueryRejecting all incoming requests!]</b>";
      }

      String msg = Integer.toString(jobs);

      int maximumThreads = node.getThreadFactory().maximumThreads();
      if (maximumThreads > 0) {
        float threadPoolLoad = (((float) jobs) / maximumThreads) * 100.0f;
        msg += " (" + Float.toString(threadPoolLoad) + "%)";
      }

      if (!comment.equals("")) {
        msg += " <font color=\"" + color + "\">" + comment + "</font><br>";
      }

      sb.append("<tr><td nowrap>Active pooled jobs</td><td>" + msg + "</td></tr>");
      sb.append("<tr><td nowrap>Available threads</td><td>" + available + "</td></tr>");

      if (rejectingConnections || rejectingRequests) {
        sb.append("<tr><td></td><td>");
        sb.append("It's normal for the node to sometimes reject connections or requests");
        sb.append("for a limited period.  If you're seeing rejections continuously the node ");
        sb.append("is overloaded or something is wrong (i.e. a bug).</td></tr>");
      }
    }
    sb.append("<tr><td nowrap>Current estimated load</td><td>" + f * 100 + "%</td></tr>");
    sb.append("</table>");
    titleBoxTemplate.set("TITLE", "Load");
    titleBoxTemplate.set("CONTENT", sb.toString());
    titleBoxTemplate.toHtml(pw);
  }

}

