package freenet.node.http.infolets;
import freenet.node.http.Infolet;
import freenet.node.http.SimpleAdvanced_ModeUtils;
import freenet.node.Node;
import freenet.node.Main;
import freenet.Core;
import freenet.support.Logger;
import freenet.fs.dir.NativeFSDirectory;
import freenet.thread.PooledThread;
import freenet.support.servlet.HtmlTemplate;
import freenet.transport.tcpAddress;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Date;
import java.text.NumberFormat;

import javax.servlet.http.HttpServletRequest;

public final class EnvironmentInfolet extends Infolet  {

    private Node node;
    private final NumberFormat nf = NumberFormat.getInstance();
    private HtmlTemplate titleBoxTmp;

    public String longName() {
        return "Environment";
    }
    
    public String shortName() {
        return "env";
    }
    
    public boolean visibleFor(HttpServletRequest req){
	return SimpleAdvanced_ModeUtils.isAdvancedMode(req);
    }
    
    public void init(Node n) {
        this.node=n;
        try {
            titleBoxTmp = HtmlTemplate.createTemplate("aqua/titleBox.tpl");
        } catch (java.io.IOException e) {
        }
    }
    
    public void toHtml(PrintWriter pw) {
	HtmlTemplate titleBoxTmp = new HtmlTemplate(this.titleBoxTmp);
        StringWriter ssw = new StringWriter(200);
        PrintWriter sw = new PrintWriter(ssw);

        sw.println("<table width=\"100%\">");
        // architecture and operation system information
        sw.println("<tr><td>Architecture</td><td align=\"right\">" + System.getProperty("os.arch") + "</td></tr>");
        try {
            sw.println("<tr><td>Available processors</td><td align=right>"+Runtime.getRuntime().getClass().getMethod("availableProcessors", null).invoke(Runtime.getRuntime(), null) + "</td></tr>");
        } catch (Throwable e) {
        }
        sw.println("<tr><td>Operating System</td><td align=right>" + System.getProperty("os.name") + "</td></tr>");
        sw.println("<tr><td>OS Version</td><td align=right>" + System.getProperty("os.version") + "</td></tr>");
		sw.println("</table>");
        titleBoxTmp.set("TITLE", "Architecture and Operating System");
        titleBoxTmp.set("CONTENT", ssw.toString());
        titleBoxTmp.toHtml(pw);
        
        // java virtual machine information
        ssw = new StringWriter(200);
        sw = new PrintWriter(ssw);
        sw.println("<table width=\"100%\">");
        sw.println("<tr><td>JVM Vendor</td><td align=right><a href=\"" + System.getProperty("java.vendor.url") + "\">" + System.getProperty("java.vm.vendor") + "</a></td></tr>");
        sw.println("<tr><td>JVM Name</td><td align=right>" + System.getProperty("java.vm.name") + "</td></tr>");
        sw.println("<tr><td>JVM Version</td><td align=right>" + System.getProperty("java.vm.version") + "</td></tr>");
		sw.println("</table>");
        titleBoxTmp.set("TITLE", "Java Virtual Machine");
        titleBoxTmp.set("CONTENT", ssw.toString());
        titleBoxTmp.toHtml(pw);

        // memory allocation
        ssw = new StringWriter(200);
        sw = new PrintWriter(ssw);
        sw.println("<table width=\"100%\">");
        try {
            long max = ((Long)Runtime.getRuntime().getClass().getMethod("maxMemory", null).invoke(Runtime.getRuntime(), null)).longValue();
            sw.println("<tr><td>Maximum memory the JVM will allocate</td><td align=right>" + ((max==Long.MAX_VALUE)?"Unlimited":format(max)) + "</td></tr>");
        } catch (Throwable e) {
        }
        sw.println("<tr><td>Memory currently allocated by the JVM</td><td align=right>" + format(Runtime.getRuntime().totalMemory()) + "</td></tr>");
        sw.println("<tr><td>Memory in use</td><td align=right>" + format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "</td></tr>");
	sw.println("<tr><td>Estimated memory used by logger</td><td align=right>" + format(Main.loggerHook().listBytes())+"</td></tr>");
        sw.println("<tr><td>Unused allocated memory</td><td align=right>" + format(Runtime.getRuntime().freeMemory()) + "</td></tr>");
		sw.println("</table>");
        titleBoxTmp.set("TITLE", "Memory Allocation");
        titleBoxTmp.set("CONTENT", ssw.toString());
        titleBoxTmp.toHtml(pw);

        // data store information
        ssw = new StringWriter(200);
        sw = new PrintWriter(ssw);
        sw.println("<table width=\"100%\">");
        long total = Main.storeSize(); // Node.storeSize is per store
        sw.println("<tr><td>Maximum size</td><td align=right>" + format(total) + "</td></tr>");
        long available = node.dir.available();
        sw.println("<tr><td>Free space</td><td align=right>" + format(available) + "</td></tr>");
        sw.println("<tr><td>Used space</td><td align=right>" + format(total - available) + "</td></tr>");
        sw.println("<tr><td>Percent used</td><td align=right>" + 100 * (total - available) / total + "</td></tr>");
        long keys = node.dir.countKeys();
        sw.println("<tr><td>Total keys</td><td align=right>" + keys + "</td></tr>");
        if (node.dir instanceof NativeFSDirectory) {
            sw.println("<tr><td>Space used by temp files</td><td align=right>" + format(((NativeFSDirectory)(node.dir)).tempSpaceUsed())+"</td></tr>");
            sw.println("<tr><td>Maximum space for temp files</td><td align=right>"+ format(((NativeFSDirectory)(node.dir)).maxTempSpace())+"</td></tr>");
            if (keys > 0) {
                sw.println("<tr><td>Most recent file timestamp</td><td align=right>" + new Date(((NativeFSDirectory)node.dir).mostRecentlyUsedTime()).toString()+"</td></tr>");
                sw.println("<tr><td>Least recent file timestamp</td><td align=right>" + new Date(((NativeFSDirectory)node.dir).leastRecentlyUsedTime()).toString()+"</td></tr>");
            }
        }
	sw.println("</table>");
        titleBoxTmp.set("TITLE", "Data Store");
        titleBoxTmp.set("CONTENT", ssw.toString());
        titleBoxTmp.toHtml(pw);
        
	if(!Main.publicNode) {
	    ssw = new StringWriter(200);
	    sw = new PrintWriter(ssw);
	    sw.println("<table width=\"100%\">");
	    tcpAddress tcp = Main.getTcpAddress();
	    String s = "(NOT RESOLVABLE)";
            if (tcp != null) try {
		s = tcp.getHost().getHostAddress();
	    } catch (java.net.UnknownHostException e) {
		// set above
	    }
	    
	    sw.println("<tr><td>Current IPv4 address</td><td align=\"right\">"
		       + ((tcp==null)?"(NOT AVAILABLE)":
                          s)+"</td></tr>");
	    sw.println("<tr><td>Current IPv4 port</td><td align=\"right\">" +
		       ((tcp==null)?"(NOT AVAILABLE)":
                        Integer.toString(tcp.getPort()))+"</td></tr>");
	    sw.println("<tr><td>ARK sequence number</td><td align=\"right\">"+
                       node.myRef.revision()+"</td></tr>");
	    long x = Main.initialARKversion;
	    try {
		sw.println("<tr><td>Last ARK sequence number inserted</td>"+
			   "<td align=\"right\"><a href=\"/"+
			   node.myRef.getARKURI(x).toString(false)+"\">"+x+
                           "</a></td></tr>");
	    } catch (freenet.KeyException e) {
		Core.logger.log(this, "Broken: "+e, e, Logger.ERROR);
		sw.println("<tr><td>ARKs broken</td></tr>");
	    }
	    sw.println("</table>");
	    titleBoxTmp.set("TITLE", "Transports");
	    titleBoxTmp.set("CONTENT", ssw.toString());
	    titleBoxTmp.toHtml(pw);
	}
	
        ThreadGroup tg = Thread.currentThread().getThreadGroup().getParent();
        ThreadGroup topMost = null;
        while(tg != null)
        {
            topMost = tg;
            tg = tg.getParent();
        }
	StringBuffer buffer = new StringBuffer();
	Hashtable consumers = new Hashtable();
	ThreadCount tc = new ThreadCount();
        doGroup(topMost, buffer, consumers, tc);
        if (!consumers.isEmpty()) {
            ssw = new StringWriter(200);
            sw = new PrintWriter(ssw);
            
            total = tc.total;
            available = tc.available;
	    sw.println("<table width=\"100%\">");
	    sw.println("<tr><td>Total pooled threads</td><td align=right>" + total + "</td></tr>");
            sw.println("<tr><td>Available pooled threads</td><td align=right>" + available + "</td></tr>");
            sw.println("<tr><td>Pooled threads in use</td><td align=right>" + (total - available) + "</td></tr>");
			sw.println("</table>");
            titleBoxTmp.set("TITLE", "Thread Pool");
            titleBoxTmp.set("CONTENT", ssw.toString());
            titleBoxTmp.toHtml(pw);

            ssw = new StringWriter(200);
            sw = new PrintWriter(ssw);
			sw.println("<table width=\"100%\">");
            sw.println("<tr><th align=\"left\">Class</th><th align=\"right\">Threads used</th>");
            Object[] types = consumers.keySet().toArray();
            java.util.Arrays.sort(types);
            for (int x = 0; x < types.length; x++)
                sw.println("<tr><td>" + types[x] + "</td><td align=\"right\">" +
			   ((Consumer) consumers.get(types[x])).number + "</td></tr>");
	    sw.println("</table>");
            titleBoxTmp.set("TITLE", "Pooled Thread Consumers");
            titleBoxTmp.set("CONTENT", ssw.toString());
            titleBoxTmp.toHtml(pw);
        }
        pw.println("</td></tr></table>");
        pw.println("<br><br>");
        pw.println("ThreadGroup/Thread Hierarchy:");
        pw.print("<ul>");
        pw.println(buffer.toString());
        pw.println("</ul><table><tr><td>");
    }

    private String format(long bytes) {
        if (bytes == 0) return "None";
        if (bytes<<4 == 0) return nf.format(bytes>>60) + " EiB";
        if (bytes<<14 == 0) return nf.format(bytes>>50) + " PiB";
        if (bytes<<24 == 0) return nf.format(bytes>>40) + " TiB";
        if (bytes<<34 == 0) return nf.format(bytes>>30) + " GiB";
        if (bytes<<44 == 0) return nf.format(bytes>>20) + " MiB";
        if (bytes<<54 == 0) return nf.format(bytes>>10) + " KiB";
        return nf.format(bytes) + " Bytes";
    }

    private void doGroup(ThreadGroup group, StringBuffer buffer,
			 Hashtable consumers, ThreadCount tc) {
        buffer.append("\n<li><b>" + group.getName() + "</b><ul>");
        Thread[] tArray = new Thread[group.activeCount()];
        int threads = group.enumerate(tArray, false);
        for(int j=0; j<threads; j++)
        {
            buffer.append("\n<li>" + tArray[j].getName());
            if (tArray[j] instanceof PooledThread) {
                tc.total++;
                try {
                    String type = ((PooledThread)tArray[j]).job().toString();
                    buffer.append(": " + type);
                    type = type.substring(0, type.indexOf("@"));
                    Consumer con = (Consumer) consumers.get(type);
                    if (con == null) {
                        con = new Consumer();
                        consumers.put(type, con);
                    }
                    con.number++;
                } catch (NullPointerException e) {
                    tc.available++;
                }
            }
        }
        ThreadGroup[] tgArray = new ThreadGroup[group.activeGroupCount()];
        int groups=group.enumerate(tgArray, false);
        for(int i=0; i<groups; i++)
        {
            doGroup(tgArray[i], buffer, consumers, tc);
        }
        buffer.append("</ul>");
    }

    private class Consumer {
        /**
         * The number of current consumers of this type.
         */
        int number = 0;
    }
    
    private class ThreadCount {
	int total = 0;
	int available = 0;
    }
}
